% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkNumeric.r
\name{checkNumeric}
\alias{assertNumeric}
\alias{assert_numeric}
\alias{checkNumeric}
\alias{expect_numeric}
\alias{testNumeric}
\alias{test_numeric}
\title{Check that an argument is a vector of type numeric}
\usage{
checkNumeric(x, lower = -Inf, upper = Inf, finite = FALSE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, unique = FALSE, names = NULL)

assertNumeric(x, lower = -Inf, upper = Inf, finite = FALSE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, unique = FALSE, names = NULL, add = NULL,
  .var.name = NULL)

assert_numeric(x, lower = -Inf, upper = Inf, finite = FALSE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, unique = FALSE, names = NULL, add = NULL,
  .var.name = NULL)

testNumeric(x, lower = -Inf, upper = Inf, finite = FALSE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, unique = FALSE, names = NULL)

test_numeric(x, lower = -Inf, upper = Inf, finite = FALSE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, unique = FALSE, names = NULL)

expect_numeric(x, lower = -Inf, upper = Inf, finite = FALSE,
  any.missing = TRUE, all.missing = TRUE, len = NULL, min.len = NULL,
  max.len = NULL, unique = FALSE, names = NULL, info = NULL,
  label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than.}

\item{finite}{[\code{logical(1)}]\cr
Check for only finite values? Default is \code{FALSE}.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with only missing values allowed? Default is \code{TRUE}.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{NULL} || \code{character(1)}]\cr
Name of the checked object to print in error message. If \code{NULL},
the name will be heuristically determined via \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertNumeric}/\code{assert_numeric}
 throws an error message, \code{testNumeric}/\code{test_numeric}
 returns \code{FALSE},
 and \code{checkNumeric} returns a string with the error message.
 The function \code{expect_numeric} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check that an argument is a vector of type numeric
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testNumeric(1)
testNumeric(1, min.len = 1, lower = 0)
}
\seealso{
Other basetypes: \code{\link{checkArray}},
  \code{\link{checkAtomicVector}},
  \code{\link{checkAtomic}}, \code{\link{checkCharacter}},
  \code{\link{checkComplex}}, \code{\link{checkDataFrame}},
  \code{\link{checkDataTable}},
  \code{\link{checkEnvironment}},
  \code{\link{checkFactor}}, \code{\link{checkFunction}},
  \code{\link{checkIntegerish}},
  \code{\link{checkInteger}}, \code{\link{checkList}},
  \code{\link{checkLogical}}, \code{\link{checkMatrix}},
  \code{\link{checkVector}}
}

