% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qassertr.r
\name{qassertr}
\alias{qassertr}
\alias{qexpectr}
\alias{qtestr}
\title{Quick recursive arguments checks on lists and data frames}
\usage{
qassertr(x, rules, .var.name = NULL)

qtestr(x, rules)

qexpectr(x, rules, info = NULL, label = NULL)
}
\arguments{
\item{x}{[\code{list} or \code{data.frame}]\cr
List or data frame to check for compliance with at least one of \code{rules}.
See details of \code{\link{qtest}} for rule explanation.}

\item{rules}{[\code{character}]\cr
Set of rules. See \code{\link{qtest}}}

\item{.var.name}{[\code{NULL} || \code{character(1)}]\cr
Name of the checked object to print in error message. If \code{NULL},
the name will be heuristically determined via \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
See \code{\link{qassert}}.
}
\description{
These functions are the tuned counterparts of \code{\link{qtest}},
\code{\link{qassert}} and \code{\link{qexpect}} tailored for recursive
checks of list elements or data frame columns.
}
\examples{
# All list elements are integers with length >= 1?
qtestr(as.list(1:10), "i+")

# All list elements (i.e. data frame columns) are numeric?
qtestr(iris, "n")

# All list elements are numeric, w/o NAs?
qtestr(list(a = 1:3, b = rnorm(1), c = letters), "N+")

# All list elements are numeric OR character
qtestr(list(a = 1:3, b = rnorm(1), c = letters), c("N+", "S+"))
}
\seealso{
\code{\link{qtest}}, \code{\link{qassert}}
}

