% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkNames.R
\name{checkNames}
\alias{assertNames}
\alias{assert_names}
\alias{checkNames}
\alias{expect_names}
\alias{testNames}
\alias{test_names}
\title{Check names to comply to specific rules}
\usage{
checkNames(x, type = "named")

assertNames(x, type = "named", .var.name = vname(x), add = NULL)

assert_names(x, type = "named", .var.name = vname(x), add = NULL)

testNames(x, type = "named")

test_names(x, type = "named")

expect_names(x, type = "named", info = NULL, label = vname(x))
}
\arguments{
\item{x}{[\code{character} || \code{NULL}]\cr
Names to check using rules defined via \code{type}.}

\item{type}{[character(1)]\cr
Select the check(s) to perform.
\dQuote{unnamed} checks \code{x} to be \code{NULL}.
\dQuote{named} (default) checks \code{x} for regular names which excludes names to be \code{NA} or empty (\code{""}).
\dQuote{unique} additionally tests for non-duplicated names.
\dQuote{strict} checks for unique names which comply to R's variable name restrictions.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertNamed}/\code{assert_named}
 throws an error message, \code{testNamed}/\code{test_named}
 returns \code{FALSE},
 and \code{checkNamed} returns a string with the error message.
 The function \code{expect_named} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Similar to \code{\link{checkNamed}} but you can pass the names directly.
}
\examples{
x = 1:3
testNames(x, "unnamed")
names(x) = letters[1:3]
testNames(x, "unique")
}

