% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qassertr.R
\name{qassertr}
\alias{qassertr}
\alias{qexpectr}
\alias{qtestr}
\title{Quick recursive arguments checks on lists and data frames}
\usage{
qassertr(x, rules, .var.name = vname(x))

qtestr(x, rules, depth = 1L)

qexpectr(x, rules, info = NULL, label = vname(x))
}
\arguments{
\item{x}{[\code{list} or \code{data.frame}]\cr
List or data frame to check for compliance with at least one of \code{rules}.
See details of \code{\link{qtest}} for rule explanation.}

\item{rules}{[\code{character}]\cr
Set of rules. See \code{\link{qtest}}}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in error messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{depth}{[\code{integer(1)}]\cr
Maximum recursion depth. Defaults to \dQuote{1} to directly check list elements or
data frame columns. Set to a higher value to check lists of lists of elements.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
See \code{\link{qassert}}.
}
\description{
These functions are the tuned counterparts of \code{\link{qtest}},
\code{\link{qassert}} and \code{\link{qexpect}} tailored for recursive
checks of list elements or data frame columns.
}
\examples{
# All list elements are integers with length >= 1?
qtestr(as.list(1:10), "i+")

# All list elements (i.e. data frame columns) are numeric?
qtestr(iris, "n")

# All list elements are numeric, w/o NAs?
qtestr(list(a = 1:3, b = rnorm(1), c = letters), "N+")

# All list elements are numeric OR character
qtestr(list(a = 1:3, b = rnorm(1), c = letters), c("N+", "S+"))
}
\seealso{
\code{\link{qtest}}, \code{\link{qassert}}
}

