% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag.R
\name{check_flag}
\alias{check_flag}
\title{Check Flag}
\usage{
check_flag(x, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if x is a flag (non-missing logical scalar).
}
\examples{
check_flag(1, error = FALSE)
check_flag(FALSE, error = FALSE)
check_flag(c(FALSE, TRUE), error = FALSE)
}
