% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgl.R
\name{check_lgl}
\alias{check_lgl}
\alias{check_flag}
\title{Check Flag}
\usage{
check_lgl(x, coerce = FALSE, x_name = substitute(x), error = TRUE)

check_flag(x, coerce = FALSE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{coerce}{A flag indicating whether to drop attributes including names.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if x is a flag (non-missing logical scalar with no attributes including names).
}
\examples{
check_lgl(1, error = FALSE)
check_lgl(FALSE, error = FALSE)
check_lgl(c(FALSE, TRUE), error = FALSE)
}
\seealso{
\code{\link{check_scalar}}
}
