% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlevels.R
\name{check_nlevels}
\alias{check_nlevels}
\title{Check nlevels}
\usage{
check_nlevels(x, nlevels = TRUE, x_name = substitute(x),
  error = TRUE)
}
\arguments{
\item{x}{The data to check.}

\item{nlevels}{A flag indicating whether x should have elements (versus no elements) or a missing value indicating no requirements or a count or count range of the number of elements.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks the number of levels of an object.
}
\examples{
check_nlevels(factor(1), error = FALSE)
check_nlevels(factor(1), nlevels = 2, error = FALSE)
}
\seealso{
\code{\link{check_levels}} and \code{\link{check_vector}}
}
