% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{check_attributes}
\alias{check_attributes}
\title{Check Attributes}
\usage{
check_attributes(x, values = NULL, exclusive = FALSE, order = FALSE,
  names = TRUE, class = TRUE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{values}{An optional vector or named list specifying the values.}

\item{exclusive}{A flag indicating whether other elements are not permitted.}

\item{order}{A flag indicating whether the elements have to occur in the same order as values.}

\item{names}{A flag specifying whether names should be considered an attribute.}

\item{class}{A flag specifying whether class should be considered an attribute.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks an objects attributes.
}
\examples{
x <- 1
attributes(x) <- list(y = 2L)
check_attributes(x, values = list(y = 3:4), error = FALSE)
}
\seealso{
\code{\link{check_list}}
}
