% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_visualization.r
\name{basis_attr_df}
\alias{basis_attr_df}
\title{Basis matrix, 1D, of the local attribution basis}
\usage{
basis_attr_df(attr_df, rownum)
}
\arguments{
\item{attr_df}{A data frame of local explanation attributions,
such as a return from \code{attr_df_treeshap()}.}

\item{rownum}{The rownumber of the observation.}
}
\value{
A matrix of the 1D basis.
}
\description{
Extract and format the 1D local attribution basis from
the provided local explanation's attribution.
}
\examples{
library(cheem)

## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Model and treeSHAP explanation:
rf_fit  <- default_rf(X, Y)
shap_df <- attr_df_treeshap(rf_fit, X, noisy = FALSE)

## Attribution basis of one obs:
basis_attr_df(shap_df, rownum = 1)
}
\seealso{
Other cheem utility: 
\code{\link{as_logical_index}()},
\code{\link{color_scale_of}()},
\code{\link{does_contain_nonnumeric}()},
\code{\link{is_discrete}()},
\code{\link{is_diverging}()},
\code{\link{linear_tform}()},
\code{\link{logistic_tform}()},
\code{\link{manip_var_of_attr_df}()},
\code{\link{problem_type}()},
\code{\link{rnorm_from}()}
}
\concept{cheem utility}
