% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chest_glm.R
\name{chest_glm}
\alias{chest_glm}
\title{Assessing confounding effects using Generalized Linear regression models}
\usage{
chest_glm(
  crude,
  xlist,
  data,
  family = "binomial",
  method = "glm.fit",
  na_omit = TRUE,
  indicate = FALSE,
  plus = "  + ",
  ...
)
}
\arguments{
\item{crude}{An object of \emph{formula} for initial model, generally crude model.
However, any other variables can also be included here as the initial model.}

\item{xlist}{A \emph{vector} of characters with all variable names of potential confounders.}

\item{data}{\emph{Data frame}.}

\item{family}{Description of the error distribution. Default is "binomial".}

\item{method}{Method to detect for singularity.}

\item{na_omit}{Remove all missing values, default: 'na_omit = TRUE'.}

\item{indicate}{indicate progress.}

\item{plus}{Change the \code{+} sign before variable names.}

\item{...}{Further optional arguments for forestplot.}
}
\value{
A table with effect estimates and their changes at all steps.
}
\description{
Please note: There is a faster option: \code{'chest_speedglm'}. \code{'chest_glm'}
is used to assess confounding effects using Generalized Linear Models, such as
logistic regression and Poisson regression with \code{'glm'}.
It presents \emph{odds ratios} or \emph{rate ratios} for the association
between exposure and outcome variables by adding other variables (potential
confounders) to the model sequentially. The order of variables to be added is
based on the magnitudes of the changes in effect estimates.
}
\examples{
chest_glm(crude = "Endpoint ~ Diabetes", xlist = c("Age", "Sex", "Married"),
na_omit=TRUE, data = diab_df)
}
\seealso{
\code{'glm'} \pkg{'stats'}
}
