% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chest_nb.R
\name{chest_nb}
\alias{chest_nb}
\title{Assessing confounding effects using Negative Binomial regression models}
\usage{
chest_nb(
  crude,
  xlist,
  data,
  method = "glm.fit",
  na_omit = TRUE,
  indicate = FALSE,
  plus = "  + ",
  ...
)
}
\arguments{
\item{crude}{An object of \emph{formula} for initial model, generally crude model.
However, any other variables can also be included here as the initial model.}

\item{xlist}{A \emph{vector} of characters with all variable names of potential confounders.}

\item{data}{\emph{Data frame}.}

\item{method}{Method to detect for singularity.}

\item{na_omit}{Remove all missing values, default: 'na_omit = TRUE'.}

\item{indicate}{indicate progress.}

\item{plus}{Change the \code{+} sign before variable names.}

\item{...}{Further optional arguments.}
}
\value{
A table with effect estimates and their changes at all steps.
}
\description{
It fits negative binomial regression models to present \emph{rate ratios} for
the association between exposure and outcome variables by adding other variables
(potential confounders) to the model sequentially. The order of variables to be
added is based on the magnitudes of the changes in effect estimates.
}
\examples{
library(MASS)
df <- quine
results <- chest_nb("Days ~ Lrn", xlist = c("Sex", "Age", "Eth"), data = df)
results$data
}
\seealso{
\code{'glm.nb'} of \pkg{'MASS'}
}
