% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aet05_all.R
\docType{data}
\name{aet05_all_pre}
\alias{aet05_all_pre}
\alias{aet05_all}
\title{\code{AET05_ALL} Table 1 (Default) Adverse Event Rate Adjusted for Patient-Years at Risk - All Occurrences.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
aet05_all_pre(adam_db, dataset = "adsaftte", ...)

aet05_all
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{dataset}{(\code{string}) the name of a table in the \code{adam_db} object.}

\item{...}{not used.}
}
\value{
the preprocessing function returns a \code{list} of \code{data.frame}.
}
\description{
The \code{AET05_ALL} table produces the standard adverse event rate adjusted for patient-years at risk summary
considering all occurrences.
}
\section{Functions}{
\itemize{
\item \code{aet05_all_pre()}: Preprocessing

}}
\examples{
library(dplyr)
library(dunlin)

proc_data <- log_filter(syn_data, PARAMCD == "AETOT1" | PARAMCD == "AEREPTTE", "adsaftte")

run(aet05_all, proc_data)

run(aet05_all, proc_data, conf_level = 0.90, conf_type = "exact")
}
\keyword{datasets}
