% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.try.catch.R
\name{model.try.catch}
\alias{model.try.catch}
\title{model.try.catch}
\usage{
model.try.catch(model.formula, data, distribution = "negative-binomial",
  maxit = 100, epsilon = 1e-08, init.theta = NULL, start = NULL,
  trace = FALSE, verbose = FALSE)
}
\arguments{
\item{model.formula}{formula}

\item{data}{model data}

\item{distribution}{Name of distribution of the counts. Options are 'negative-binomial', 
'poisson', 'truncated-poisson', and 'truncated-negative-binomial'}

\item{maxit}{Maximum number of IWLS iterations for fitting the model (passed to \code{glm.control})}

\item{epsilon}{Positive convergence tolerance for Poisson and negative binomial models. Passed to \code{glm.control}}

\item{init.theta}{Initial value of theta in negative binomial model}

\item{start}{starting values of coefficients in linear predictor}

\item{trace}{Logical indicating if output should be produced for each of model fitting procedure. Passed to \code{glm.control} or \code{gamlss.control}}

\item{verbose}{Logical indicating whether to print progress reports.}
}
\value{
List with elements
 \item{model}{model object. Set to NULL if no model could be fit.}
	\item{expected.values}{vector of expected values for each element in original data, or vector of NAs if no model could be fit}
	\item{p.values}{vector of p-values for test of significantly higher response than expected, or vector of NAs if no model could be fit}
}
\description{
Internal function for fitting model within a tryCatch loop, handling numerical errors gracefully.
}
