# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Parallel computation of the Wasserstein distances between cluster centroid and points in the cluster
#'  
#' @param X_cumsum is a Filebacked data cummulative sum matrix n x N
#' @param rowInd is a vector of the row indeces
#' @param colInd is a vector of the column indeces
#' @param C_cumsum is a vector of the cummulative sum of the cluster centroid
#' @return The vector of the Wasserstein distances
#' @export
#' @keywords internal
W1_cl_centr <- function(X_cumsum, rowInd, colInd, C_cumsum) {
    .Call(`_chickn_W1_cl_centr`, X_cumsum, rowInd, colInd, C_cumsum)
}

#' Computation of the Wasserstein distances between cluster centroid and signals in the cluster
#'  
#' @param X_cumsum is a Filebacked data cummulative sum matrix n x N
#' @param rowInd is a vector of the row indeces
#' @param colInd is a vector of the column indeces
#' @param C_cumsum is a vector of the cummulative sum of the cluster centroid
#' @export
#' @return The vector of the Wasserstein distances
#' @keywords internal
IntraDist <- function(X_cumsum, rowInd, colInd, C_cumsum) {
    .Call(`_chickn_IntraDist`, X_cumsum, rowInd, colInd, C_cumsum)
}

#'@title cumsum_sug
#' @description rcpp cummulative sum of integer vector 
#' @param x is a numeric vector
#' @return A vector of cummulative sum
#' @export
#' @keywords internal
cumsum_sug <- function(x) {
    .Call(`_chickn_cumsum_sug`, x)
}

#'@title cumsum_Mat
#' @description rcpp cummulative sum of matrix columns 
#' @param C is a numeric matrix
#' @export
#' @return A matrix of cummulative sum
#' @keywords internal
cumsum_Mat <- function(C) {
    .Call(`_chickn_cumsum_Mat`, C)
}

#' Computation of the Wasserstein distances between cluster centroids
#'  
#' @param C_cumsum is a Filebacked data cummulative sum matrix of N cluster centroids
#' @export
#' @return N x N matrix of the Wasserstein distances
#' @keywords internal
InterDist <- function(C_cumsum) {
    .Call(`_chickn_InterDist`, C_cumsum)
}

#' Parallel computation of the Wasserstein distances between cluster centroids
#'  
#' @param C_cumsum is a Filebacked data cummulative sum matrix of N cluster centroids
#' @param Dist is a Filebacked inter distance matrix
#' @export
#' @return N x N matrix of the Wasserstein distances
#' @keywords internal
W1_centr_centr <- function(C_cumsum, Dist) {
    invisible(.Call(`_chickn_W1_centr_centr`, C_cumsum, Dist))
}

#'@title W1_cl_centr_BIG
#'@description Parallel computation for big clusters of
#'  the Wasserstein distances between cluster centroid and signals in the cluster
#' @param X_cumsum is a Filebacked data cummulative sum matrix n x N
#' @param rowInd is a vector of the row indeces
#' @param colInd is a vector of the column indeces
#' @param C_cumsum is a vector of the cummulative sum of the cluster centroid
#' @param nbr_cluster is a number of clusters
#' @export
#' @return A vector of the Wasserstein distances
#' @keywords internal
W1_cl_centr_BIG <- function(X_cumsum, rowInd, colInd, C_cumsum, nbr_cluster) {
    .Call(`_chickn_W1_cl_centr_BIG`, X_cumsum, rowInd, colInd, C_cumsum, nbr_cluster)
}

#' Parallel computation for big clusters of the Wasserstein distances between cluster centroids
#'   
#' @param C_cumsum is a Filebacked data cummulative sum matrix n x N
#' @param Dist is a Filebacked matrix of the Wasserstein distances between centroids
#' @export
#' @return NULL
#' @keywords internal
W1_centr_centr_BIG <- function(C_cumsum, Dist) {
    invisible(.Call(`_chickn_W1_centr_centr_BIG`, C_cumsum, Dist))
}

#' @title DBindex
#' @description Davies Bouldin index computation. 
#' @param X_cumsum is a Filebacked Big Matrix, which contains column matrix cumulative sums.
#' @param rowInd is a vector of the row indeces
#' @param Clusters is a list of cluster assignment
#' @param C is a matrix of the cluster centroids
#' @param cluster_size is a vector of the cluster sizes
#' @param DistInter is a Filebacked Big Matrix, which stores distances between a cluster centoid and signals in the cluster
#' @export
#' @return A value of the DB index
#' @keywords internal
DBindex <- function(X_cumsum, rowInd, Clusters, C, cluster_size, DistInter) {
    .Call(`_chickn_DBindex`, X_cumsum, rowInd, Clusters, C, cluster_size, DistInter)
}

#' @title DBindex_BIG
#' @description Davies Bouldin index computation 
#' @param X_cumsum is a Filebacked data cummulative sum matrix n x N
#' @param rowInd is a vector of the row indeces
#' @param Clusters is a list of cluster assignment
#' @param C is a matrix of the cluster centroids
#' @param C_cumsum is a matrix of the cummulative sums of cluster centroids
#' @param cluster_size is a vector of the cluster sizes
#' @param DistInter is a matrix of the inter distances
#' @param R is a matrix of the intra distances
#' @export
#' @return A value of the DB index
#' @keywords internal
DBindex_BIG <- function(X_cumsum, rowInd, Clusters, C, C_cumsum, cluster_size, DistInter, R) {
    invisible(.Call(`_chickn_DBindex_BIG`, X_cumsum, rowInd, Clusters, C, C_cumsum, cluster_size, DistInter, R))
}

#' @title G_fun_cpp
#' @description Function for gradient computation. 
#' @param x is a vector
#' @param y is a vector
#' @param W is a frequency matrix
#' @return A vector
#' @keywords internal
#' @export
G_fun_cpp <- function(x, y, W) {
    .Call(`_chickn_G_fun_cpp`, x, y, W)
}

#'@title Objective function 
#'@description Objective function of the minimization with respect to the cluster centroids
#'
#'@param c is a cluster centroid 1xn
#'@param W is a frequency matrix mxn
#'@param residue is a vector
#'@return The objective function value 
#'@details The residue vector is equal to \eqn{(Sketch(Data, W) - \sum_{k=1}^K \alpha_k *Sketch(c_k, W))}. 
#'@export
#'@keywords internal
ObjFun_OMP_cpp <- function(c, W, residue) {
    .Call(`_chickn_ObjFun_OMP_cpp`, c, W, residue)
}

#' @title Gradient OMP
#'@description Gradient with respect to cluster centroid vector
#'
#'@param c is a cluster centroid
#'@param W is a frequency matrix mxs
#'@param residue is a vector  
#'@return The gradient vector
#'@keywords internal 
#'@export
Gradient_OMP_cpp <- function(c, W, residue) {
    .Call(`_chickn_Gradient_OMP_cpp`, c, W, residue)
}

#'@title Gradient and objective function
#'@description Global objective function and gradient computations with respect to cluster centroid vectors and their weights.
#'
#'@param x is a data vector. Its first K*n components are cluster centroids and its last K components are the centroid weights. 
#'@param SK is a data sketch vector. 
#'@param W is a frequency matrix.
#'@param K is a number of cluster centroids. 
#'@return \itemize{
#'           \item \code{gradient} is a gradient vector
#'           \item \code{objective} is an objective function value \eqn{\|SK - \sum_{k=1}^K \alpha_k Sketch(c_k, W)\|}} 
#' @keywords internal
#'@export
Gradient_cpp <- function(x, SK, W, K) {
    .Call(`_chickn_Gradient_cpp`, x, SK, W, K)
}

#' @title RandIndex
#' @description Rand Index computation
#' @param Data is a two columns matrix. First column contains the clustering assignment result, 
#' second column ground truth clustering assignment each row correspond to the data vector index.
#' @return The rand index value
#' @export
#' @keywords internal
RandIndex <- function(Data) {
    .Call(`_chickn_RandIndex`, Data)
}

#' @title Kernel parameter estimation
#' @description Kernel parameter estimation by averaging the distances to the closest neighbors.
#' @param X A Filebacked Big Matrix \eqn{n \times N}.
#' @param size Neighborhood size.
#' @param kernel_type Kernel function type. Available types are c("Gaussian", "Laplacian").
#' @return The estimated kernel parameter.
#' @export
gamma_estimation <- function(X, size, kernel_type) {
    .Call(`_chickn_gamma_estimation`, X, size, kernel_type)
}

#' @title Cumulative sum computation
#' @description Parallel implementation of the cumulative sum of the matrix columns.
#' @param X A Filebacked Big Matrix n x N.
#' @param A_cumsum A Filebacked Big Matrix n x N, where cummulative sums are stored.
#' @return NULL
#' @export
cumsum_parallel <- function(X, A_cumsum) {
    invisible(.Call(`_chickn_cumsum_parallel`, X, A_cumsum))
}

#' @title Wasserstein-1 distance 
#' @param X A Filebacked Big Matrix n x N.
#' @param C A Filebacked Big Matrix N x l, which stores the Wasserstein distances. 
#' @param set_c Column index vector. The data vector indices for which the Wasserstein distances are computed. 
#' @return NULL
#' @details The Wasserstein-1 distances are computed between the data vectors from \code{set_c} and all columns of X. 
#' @export
W1_parallel <- function(X, C, set_c) {
    invisible(.Call(`_chickn_W1_parallel`, X, C, set_c))
}

#' @title Euclidean distance 
#' @param X A Filebacked Big Matrix \eqn{n \times N}.
#' @param C A Filebacked Big Matrix \eqn{N \times l}, which stores the Euclidean distances. 
#' @param set_c Column index vector. The data vector indices for which the Euclidean distances are computed. 
#' @return NULL
#' @details The Euclidean distances are computed between the data vectors from \code{set_c} and all columns of X. 
#' @export
E_parallel <- function(X, C, set_c) {
    invisible(.Call(`_chickn_E_parallel`, X, C, set_c))
}

