% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateFrequencies.R
\name{GenerateFrequencies}
\alias{GenerateFrequencies}
\title{Frequency vector construction}
\usage{
GenerateFrequencies(Data, m, N0 = 5000, TypeDist = "AR", verbose = FALSE, ...)
}
\arguments{
\item{Data}{A Filebacked Big Matrix n x N with data vectors in columns.}

\item{m}{Number of frequency vectors.}

\item{N0}{Number of data vectors used for the variance estimation in \code{\link{EstimSigma}}.}

\item{TypeDist}{Frequency distribution type. Possible values: "G" (Gaussian),
"FG" (Folded Gaussian radial) or "AR" (Adapted radius). Default is "AR".}

\item{verbose}{logical that indicates whether dysplay the process steps.}

\item{...}{Additional arguments passed on to \code{\link{EstimSigma}} and \code{\link{DrawFreq}} functions.}
}
\value{
A list with the following attributes:
\itemize{
\item \code{W} is the frequency matrix with m frequency vectors in rows.
\item \code{sigma} is the estimated data variance.
}
}
\description{
Function performs the data variance estimation and the frequency matrix construction.
}
\details{
The data variance is estimated on the \code{N0} data vectors randomly selected from \code{Data}
using \code{\link{EstimSigma}} function. The frequency vectors are sampled using \code{\link{DrawFreq}} function.
}
\examples{
X = matrix(rnorm(1000), ncol=100, nrow = 10)
X_FBM = bigstatsr::FBM(init = X, ncol=100, nrow = 10)
W = GenerateFrequencies(Data = X_FBM, m = 20, N0 = 100, TypeDist = "AR")$W
}
\references{
\insertRef{DBLP:journals/corr/KerivenBGP16}{chickn}.
}
\seealso{
\code{\link{DrawFreq}}, \code{\link{EstimSigma}}, \code{\link{Sketch}}
}
