% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/childesr.R
\name{get_contexts}
\alias{get_contexts}
\title{Get the utterances surrounding a token(s)}
\usage{
get_contexts(collection = NULL, language = NULL, corpus = NULL,
  role = NULL, role_exclude = NULL, age = NULL, sex = NULL,
  target_child = NULL, token, window = c(0, 0),
  remove_duplicates = TRUE, connection = NULL,
  db_version = "current", db_args = NULL)
}
\arguments{
\item{collection}{A character vector of one or more names of collections}

\item{language}{A character vector of one or more languages}

\item{corpus}{A character vector of one or more names of corpora}

\item{role}{A character vector of one or more roles to include}

\item{role_exclude}{A character vector of one or more roles to exclude}

\item{age}{A numeric vector of an age or a min age (inclusive) and max age
(exclusive) in months}

\item{sex}{A character vector of values "male" and/or "female"}

\item{target_child}{A character vector of one or more names of children}

\item{token}{A character vector of one or more token patterns (`\%` matches
any number of wildcard characters, `_` matches exactly one wildcard
character)}

\item{window}{A length 2 numeric vector of how many utterances before and
after each utterance containing the target token to retrieve}

\item{remove_duplicates}{A boolean indicating whether to remove duplicate
utterances from the results}

\item{connection}{A connection to the CHILDES database}

\item{db_version}{String of the name of database version to use}

\item{db_args}{List with host, user, and password defined}
}
\value{
A 'tbl' of Utterance data, filtered down by supplied arguments.
}
\description{
Get the utterances surrounding a token(s)
}
\examples{
\donttest{
get_contexts(target_child = "Shem", token = "dog")
}
}
