% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{sds.df,refs-method}
\alias{sds.df,refs-method}
\title{calculates standard deviation scores according to a given reference and adds the respective column}
\usage{
\S4method{sds.df}{refs}(object, df, item, value = "value", age = "age",
  sex = "sex", male = 0, female = 1)
}
\arguments{
\item{object}{\code{\linkS4class{refs}} object}

\item{df}{dataframe}

\item{item}{reference contained in \code{object}}

\item{sex}{name of the column containing sex}

\item{age}{name of the column containing age}

\item{value}{name of the column containing numeric value which should transform into SDscore}

\item{male}{coding for male}

\item{female}{coding for female}
}
\description{
calculates standard deviation scores according to a given reference and adds the respective column
}
\examples{
data(who.ref)
x <- data.frame(height=c(50,100,60,54),
                sex=c("m","f","f","m"),
                age=c(0,2.9,0.6,0.2))
sds.df(who.ref,df=x,item="height",value="height",sex="sex",age="age",male="m",female="f")
}

