% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_multi_pheno_trend_plot.R
\name{make_multi_pheno_trend_plot}
\alias{make_multi_pheno_trend_plot}
\title{Combine multiple phenology contour plots in one figure}
\usage{
make_multi_pheno_trend_plot(pheno_list, fixed_weather, split_month = 6,
  outpath = NA, file_name = NA, image_type = "png", fonttype = "serif",
  percol = 5, xlabel = NA, ylabel = NA, height_factor = 0.8)
}
\arguments{
\item{pheno_list}{a data.frame with the following columns: varieties
(contains a character string), Start_chill (the start of the chill period,
in Julian days), End_chill (the end of the chill period, in Julian days),
Start_heat (the start of the forcing period, in Julian days), End_heat (the
end of the forcing period, in Julian days), Link (the complete path to a csv
file that contains all the annual observations for the dataset, with columns
Year and pheno)}

\item{fixed_weather}{daily weather, as produced with the fix_weather
function}

\item{split_month}{the month after which to start a new season. Defaults to
6, meaning the new season will start in July.}

\item{outpath}{Path to the folder where the images should be saved. Should
include a trailing "/". The folder must already exists.}

\item{file_name}{name of the image file to be produced, if image_type='png'.}

\item{image_type}{Character string indicating the file format that should be
output. Image files are only produced for the moment, if this is "png". All
other values, as well as the default NA lead to output as an R plot only.}

\item{fonttype}{The type of font to be used for the figures. Can be 'serif'
(default) for a Times New Roman like font, 'sans' for an Arial type font or
'mono' for a typewriter type font.}

\item{percol}{number of plots to be placed in a column.}

\item{xlabel}{label for the x-axis (if unhappy with the default).}

\item{ylabel}{label for the y-axis (if unhappy with the default).}

\item{height_factor}{height of the resulting png figure (if this is a png)
relative to the width of the plot (e.g. 1 or 0.7, defaults to 0.8).}
}
\value{
Only a side effect is produced: either a .png file or an R graphic
showing the multi-panel contour figure.
}
\description{
For multiple datasets, this function plots surface plots relating mean
temperatures during specified periods to annually recurring variables (e.g.
flowering). It produces one panel per dataset and plots them all in one
figure. Plots can be produced in R or directly exported as .png files.
}
\details{
This function is only useful, if you want to plot several surface plots in
the same figure. These must relate to the same weather dataset. Arguably,
this function isn't quite ready to be released, but it performs some useful
functions that you may be interested in...
}
\examples{

#this example uses arbitrarily modified versions of the KA_bloom dataset, and the starts
#end ends of the periods are also arbitraty. So the outputs may not make a lot of sense...

weather<-fix_weather(KA_weather[which(KA_weather$Year>2000),])
pheno_list<-data.frame(varieties=c("KA1","KA2","KA3","KA4"), Start_chill=c(270,305,315,320),
  End_chill=c(15,20,35,40), Start_heat=c(17,25,40,45),End_heat=c(90,100,110,115),
  Link=c("KA1.csv","KA2.csv","KA3.csv","KA4.csv"))
  
 write.csv(KA_bloom,"KA1.csv",row.names=FALSE)
 KA_bloom$pheno<-as.numeric(as.character(KA_bloom$pheno))+10
 write.csv(KA_bloom,"KA2.csv",row.names=FALSE)
 KA_bloom$pheno<-KA_bloom$pheno+10
 write.csv(KA_bloom,"KA3.csv",row.names=FALSE)
 KA_bloom$pheno<-KA_bloom$pheno+10
 write.csv(KA_bloom,"KA4.csv",row.names=FALSE)

make_multi_pheno_trend_plot(pheno_list,weather, split_month=6,
           outpath=NA,file_name=NA,image_type="",fonttype="serif",percol=2)

 
}
\author{
Eike Luedeling
}
\keyword{utility}

