% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_temperature_scenarios.R
\name{load_temperature_scenarios}
\alias{load_temperature_scenarios}
\title{Load temperature scenarios}
\usage{
load_temperature_scenarios(path, prefix)
}
\arguments{
\item{path}{character string indicating the file path where the files are to be written.}

\item{prefix}{character string specifying the prefix for all files.}
}
\value{
a list of temperature scenarios.
}
\description{
The temperature_generation can produce synthetic temperature scenarios, but it can take a while
to run, especially for large ensembles of climate scenarios. The save_temperature_scenarios
function can then save these scenarios to disk as a series of .csv files, so that they can
later be used again, without re-running the generation function.
Conversely, the load_temperature_scenarios function allows reading the data back into R.
This function also works with any other list of data.frames.
}
\examples{

temps<-list(Element1=data.frame(a=1,b=2),Element2=data.frame(a=c(2,3),b=c(8,4)))
save_temperature_scenarios(temps,path=getwd(),prefix="temperatures")
temps_reloaded<-load_temperature_scenarios(path=getwd(),prefix="temperatures")

 
}
\author{
Eike Luedeling
}
\keyword{utility}
