% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_temperature_scenario.R
\name{check_temperature_scenario}
\alias{check_temperature_scenario}
\title{Check temperature scenario for consistency}
\usage{
check_temperature_scenario(temperature_scenario, n_intervals = 12,
  check_scenario_type = TRUE, scenario_check_thresholds = c(-5, 10),
  update_scenario_type = TRUE, warn_me = TRUE)
}
\arguments{
\item{temperature_scenario}{can be one of two options:
1) a data.frame with two columns Tmin and Tmax and n_intervals (default: 12) rows containing
temperature changes for all time intervals, or absolute temperatures for these intervals.
2) a temperature scenario object, consisting of the following elements: 'data' = a data frame with
n_intervals elements containing the absolute or relative temperature information (as in input option 1);
'scenario_year' = the year the scenario is representative of; 'reference_year' = the year the scenario is representative of; 'scenario_type' = the scenario type
('absolute' or 'relative' - if NA, this is assigned automatically); 'labels' = and elements
attached to the input temperature_scenario as an element names 'labels'. A subset of these elements can
also be specified, but 'data' must be present.}

\item{n_intervals}{the number of time intervals specified in the temperature scenarios. This
is often the number of months in a year, so the default is 12. If the temperature scenario is
specified for a different number of time intervals, this should be adjusted.}

\item{check_scenario_type}{boolean variable indicating whether the specified (or unspecified)
scenario type should be verified, i.e. whether the scenario is a relative or absolute temperature
scenario.}

\item{scenario_check_thresholds}{vector with two numeric elements specifying the thresholds
for checking whether the scenario is an absolute or relative temperature scenario. These are the
minimum (first value) and maximum (second value) plausible changes in a relative temperature
scenario. The test only works in settings where either the lowest mean minimum temperature
across all time intervals is below the stated minimum threshold or the highest mean maximum
temperature across all time intervals is above the maximum threshold. With the default values
c(-5,10), this should be the case for most locations on Earth, but in extreme cases (either for
extreme change scenarios or where all monthly minimum and maximum temperatures are between -5
and 10 degrees), this may need adjustment. This is only used if check_scenario_type==TRUE.}

\item{update_scenario_type}{boolean variable stating whether, if scenario type is found to be
inconsistent with the numbers, the scenario_type should be updated. Defaults to TRUE and is only
used if check_scenario_type==TRUE.}

\item{warn_me}{boolean variable specifying whether warnings should be shown. Defaults to TRUE.}
}
\value{
temperature scenario object, consisting of the following elements: 'data' = a data frame with
n_intervals elements containing the absolute or relative temperature information. 'reference_year' =
the year the scenario is representative of. 'scenario_type' = the scenario type ('absolute' or 'relative');
'labels' = and elements attached to the input temperature_scenario as an element names 'labels'.

The function also returns warnings, where elements are missing or the scenario_type appears to be
wrong, and it stops with an error, if the scenario isn't specified in a format that is usable by
chillR.
}
\description{
chillR's temperature generation procedures require absolute or relative temperature scenarios.
This function checks these scenarios for consistency, regarding the data format, the reference
year, and whether they are relative or absolute scenarios (based on specified criteria).
}
\examples{

temperature_scenario<-list(data=data.frame(Tmin=c(-5,-2,0, 4, 9,12,15,13,12, 9, 4,0),
                                       Tmax=c( 0, 4,8,12,15,18,21,19,17,14,11,5)),
                                       reference_year=1975,scenario_type="absolute",
                                       labels=list(GCM="none",RCM="none",Time="1950-2000"))

checked_temperature_scenario<-check_temperature_scenario(temperature_scenario,n_intervals=12,
   check_scenario_type=FALSE,scenario_check_thresholds=c(-5,10),update_scenario_type=FALSE)
                                            
checked_temperature_scenario<-check_temperature_scenario(temperature_scenario,n_intervals=12,
   check_scenario_type=TRUE,scenario_check_thresholds=c(-5,10),update_scenario_type=FALSE)
                                            
checked_temperature_scenario<-check_temperature_scenario(temperature_scenario,n_intervals=12,
  check_scenario_type=TRUE,scenario_check_thresholds=c(-5,10),update_scenario_type=TRUE)
                                            
                                            
 
}
\author{
Eike Luedeling
}
\keyword{utility}
