% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temp_models.R
\name{GDH_model}
\alias{GDH_model}
\title{Calculation of cumulative heat according to the Growing Degree Hours Model
(alternative function name)}
\usage{
GDH_model(HourTemp, summ = TRUE)
}
\arguments{
\item{HourTemp}{Vector of hourly temperatures.}

\item{summ}{Boolean parameter indicating whether calculated metrics should
be provided as cumulative values over the entire record (TRUE) or as the
actual accumulation for each hour (FALSE).}
}
\value{
Vector of length length(HourTemp) containing the cumulative Growing
Degree Hours over the entire duration of HourTemp.
}
\description{
This function calculates heat for temperate trees according to the Growing
Degree Hours Model.
}
\details{
Growing Degree Hours are calculated as suggested by Anderson et al. (1986).
}
\examples{

weather<-fix_weather(KA_weather[which(KA_weather$Year>2006),])

hourtemps<-stack_hourly_temps(weather,latitude=50.4)

GDH_model(hourtemps$hourtemps$Temp)

}
\references{
Growing Degree Hours reference:

Anderson JL, Richardson EA, Kesner CD (1986) Validation of chill unit and
flower bud phenology models for 'Montmorency' sour cherry. Acta Hortic 184,
71-78
}
\author{
Eike Luedeling
}
\keyword{and}
\keyword{calculation}
\keyword{chill}
\keyword{heat}
