% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bloom_prediction3.R
\name{bloom_prediction3}
\alias{bloom_prediction3}
\title{Bloom prediction from chilling and forcing requirements, assumed to be
fulfilled strictly in sequence - version 3}
\usage{
bloom_prediction3(hourtemps, Chill_req, Heat_req,
  models = c(Chill_Portions = Dynamic_Model, GDH = GDH_model),
  permutations = FALSE, Chill_model = "Chill_Portions",
  Heat_model = "GDH", Start_JDay = 305, infocol = NULL)
}
\arguments{
\item{hourtemps}{a data frame of hourly temperatures (e.g. resulting from
the stack_hourly_temps function - should have columns "Year", "Month",
"Day" and "Temp").}

\item{Chill_req}{numeric vector indicating one or multiple chilling
requirements of the particular growth stage (in the unit specified by
"Chill_model")}

\item{Heat_req}{numeric vector indicating one or multiple heat requirements
of the particular growth stage (in Growing Degree Hours)}

\item{models}{named list of models that should be applied to the hourly
temperature data. These should be functions that take as input a vector of
hourly temperatures. This defaults to c(Chill_Portions = Dynamic_Model, GDH
= GDH_model), which refer to the Dynamic chill model and the Growing Degree
Hours model functions contained in chillR.}

\item{permutations}{boolean parameter indicating whether all possible
combinations of the supplied chilling and heat requirements should be used.
Defaults to FALSE, which means that the function matches chilling and heat
requirements according to their positions in the Chill_req and Heat_req
vectors and only predicts stage occurrence dates for these combinations.}

\item{Chill_model}{character string specifying the chill model to use. This
has to correspond to the name of the column in HourChillTable that contains
the chill accumulation (default is "Chill_Portions" for units of the Dynamic
Model).}

\item{Heat_model}{character string specifying the heat model to use. This
has to correspond to the name of the column in HourChillTable that contains
the heat accumulation (e.g "GDH").}

\item{Start_JDay}{numeric parameter indicating the day when chill
accumulation is supposed to start. Note that this is also the latest
acceptable bloom date.}

\item{infocol}{a vector of length length(Chill_req) which contains additional
information for each element of the vector. This is preserved and included
in the output. This only works when permutation=FALSE, and is meant to
facilitate recognition of particular phenological events in the output.}
}
\value{
data frame containing the predicted Julian dates of chilling requirement
fulfillment and timing of the phenological stage. Columns are Season, Creq, Hreq,
Creq_full (day when the chilling requirement is fulfilled) and Pheno_date
(the predicted date of the phenological event).
}
\description{
This is a pretty rudimentary function to predict phenological dates from
chilling and forcing requirements and hourly chilling and forcing data. Note
that there are enormous uncertainties in these predictions, which are hardly
ever acknowledged. So please use this function with caution.
}
\details{
This function is an update to the bloom_prediction and bloom_prediction2
functions. This version takes hourly temperatures as input rather than
requiring pre-calculated chill and heat records. This functionality is
now integrated in the function, so that users can now specify a list of
temperature metrics/models to be computed and used in the bloom prediction.
}
\examples{


hourtemps<-stack_hourly_temps(fix_weather(KA_weather[which(KA_weather$Year>2007),]),latitude=50.4)

bloom_prediction3(hourtemps,c(30,140,50),c(1000,1500,2000))

bloom_prediction3(hourtemps,c(30,40,50),c(1000,1500,2000),permutations=TRUE,Start_JDay=1)

bloom_prediction3(hourtemps,c(300,400,600),c(100,150,200),permutations=TRUE,Start_JDay=1,
    models=c(CH=Chilling_Hours,Heat=GDD),Chill_model = "CH", Heat_model="Heat")

}
\references{
Model references:

Dynamic Model:

Erez A, Fishman S, Linsley-Noakes GC, Allan P (1990) The dynamic model for
rest completion in peach buds. Acta Hortic 276, 165-174

Fishman S, Erez A, Couvillon GA (1987a) The temperature dependence of
dormancy breaking in plants - computer simulation of processes studied under
controlled temperatures. J Theor Biol 126(3), 309-321

Fishman S, Erez A, Couvillon GA (1987b) The temperature dependence of
dormancy breaking in plants - mathematical analysis of a two-step model
involving a cooperative transition. J Theor Biol 124(4), 473-483

Growing Degree Hours:

Anderson JL, Richardson EA, Kesner CD (1986) Validation of chill unit and
flower bud phenology models for 'Montmorency' sour cherry. Acta Hortic 184,
71-78
}
\author{
Eike Luedeling
}
\keyword{bloom}
\keyword{prediction}
