% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getClimateWizard_scenarios.R
\name{getClimateWizard_scenarios}
\alias{getClimateWizard_scenarios}
\title{Extract mutltiple scenarios from the ClimateWizard database}
\usage{
getClimateWizard_scenarios(
  coordinates,
  scenarios,
  start_years,
  end_years,
  baseline = c(1950, 2005),
  metric = "monthly_min_max_temps",
  GCMs = "all"
)
}
\arguments{
\item{coordinates}{position of the point of interest, specified by a vector
with two elements that are called longitude and latitude (e.g. c(longitude=10,
latitude=20)).}

\item{scenarios}{vector of representative concentration pathway scenarios. Can only be
"historical", "rcp45" or "rcp85".}

\item{start_years}{vector of start year of the intervals, for which data is to be summarized.
Must be of same length as scenarios.}

\item{end_years}{vector of end years of the intervals, for which data is to be summarized.
Must be of same length as scenarios.}

\item{baseline}{numeric vector of length 2 indicating the time interval to be used
as baseline for the climate scenario. The function then returns projected values relative
to this baseline. Defaults to c(1950,2005) for the standard
baseline of the ClimateWizard dataset. This can also assume different values, but it must
span an interval of at least 20 years within the [1950; 2005] interval. Needs
to be set to NA for the function to return absolute values.}

\item{metric}{vector of metrics to output, from a list specified in the reference
provided above. This can also be "monthly_min_max_temps", which returns all
mean monthly minimum and maximum temperatures, or "precipitation" for precipitation
data for all months, or "monthly_tmean" for the mean monthly temperatures of all months.}

\item{GCMs}{vector of GCMs to be accessed, from a list specified in the above
reference. This can also be "all" for all available GCMs (as of January 2018).}
}
\value{
data.frame containing the requested information.
}
\description{
This function is a wrapper for the getClimateWizardData function to access climate
scenario data for a location of interest. Climate model runs are queried
and data returned and summarized according to the specified parameters.
A number of metrics are available for several climate models, which are listed in
https://github.com/CIAT-DAPA/climate_wizard_api.
This function can download data for multiple climate scenarios, saving users the
effort to retrieve them separately.
}
\details{
Note that this function lacks quality checks. If something goes wrong, you may
consider checking individual scenarios with the getClimateWizardData function.
}
\examples{

#example is #d out, because of runtime issues.
#getC<-getClimateWizard_scenarios(coordinates=c(longitude=6.99,latitude=50.62),
#                                scenarios=c("rcp85","rcp45"),
#                                start_years=c(2070,2035),
#                                end_years=c(2100,2065),
#                                metric=c("monthly_tmean"),
#                                GCMs=c("all"))


}
\references{
Girvetz E, Ramirez-Villegas J, Navarro C, Rodriguez C, Tarapues J, undated.
ClimateWizard REST API for querying climate change data.
https://github.com/CIAT-DAPA/climate_wizard_api
}
\author{
Eike Luedeling
}
\keyword{utility}
