% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_phenologyFit.R
\name{bootstrap.phenologyFit}
\alias{bootstrap.phenologyFit}
\title{bootstrap.phenologyFit}
\usage{
bootstrap.phenologyFit(
  object,
  boot.R = 99,
  control = list(smooth = FALSE, verbose = FALSE, maxit = 1000, nb.stop.improvement =
    250),
  lower,
  upper,
  seed = 1766588
)
}
\arguments{
\item{object}{class `phenologyFit`, the object to bootstrap}

\item{boot.R}{integer. The number of bootstrap replicates}

\item{control}{control parameters to `GenSA`, see `GenSA::GenSA`}

\item{lower}{Vector with length of ‘par.guess’. Lower bounds for components.}

\item{upper}{Vector with length of ‘par.guess’. Upper bounds for components.
If missing, `upper` in `object` is used.}

\item{seed}{integer seed for the random number generator used by `GenSA`.
If missing, `lower` in `object` is used.}
}
\value{
Invisibly returns a list with elements `boot.R`, `object`, `seed`, `residuals`,
`lower`, `upper`, and `res`. The latter list `res` has `boot.R` elements, which
are lists again. Each of these lists contains named elements `par`, `value`,
`bloomJDays`, and `pbloomJDays`. `par` are the best fit parameters on the particular bootstrap 
replicate, `value` the corresponding RSS, `bloomJDays` the re-sampled data and `pbloomJDays`
the predicted bloom JDays for this sample.
}
\description{
This function bootstraps the residuals of a `phenologyFit`. It
internally calls `phenologyFitter` on each bootstrap
replicate.
}
\details{
bootstrap an object of S3 class `phenologyFit`
}
\author{
Carsten Urbach <urbach@hiskp.uni-bonn.de>
}
