% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.numeric2.R
\name{as.numeric2}
\alias{as.numeric2}
\title{An Enhanced Version of as.numeric}
\usage{
as.numeric2(x)
}
\arguments{
\item{x}{an object to be coerced.}
}
\value{
a numeric vector, or, if fails, an error will be raised.
}
\description{
This function coerces an object into a numeric vector. There are several differences between 
this function and \code{as.numeric}. First, if \code{as.character2} fails to coerce (this is 
usually because there are characters in the input object), it will raise an error and stop 
rather than to give a warning. Second, it can handle data frame object, list, and recursive 
list. Third, it can coerce number-like factors exactly into what users see on the screen.
}
\examples{
# Try to coerce data frame
a <- c(55, 66, 77, 88, 66, 77, 88)
b <- factor(a)
df <- data.frame(a, b)
as.numeric2(df)
# Try a list
l <- list(a, a*2)
as.numeric2(l)
# Try a list of lists
l2 <- list(l, l)
as.numeric2(l2)
}

