% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m3m.R
\name{m3m}
\alias{m3m}
\title{Convert Objects among matrix, dgCMatrix, simple_triplet_matrix, 
DocumentTermMatrix, TermDocumentMatrix}
\usage{
m3m(x, to, keep_name = TRUE)
}
\arguments{
\item{x}{object of class matrix, dgCMatrix, simple_triplet_matrix, 
DocumentTermMatrix, TermDocumentMatrix.}

\item{to}{to what class do you want to convert \code{x} to. Abbreviations 
can be used: "matrix" and "m" mean "matrix": "dgCMatrix" and "M" 
mean "dgCMatrix"; "simple_triplet_matrix" and "stm" mean 
"simple_triplet_matrix"; "DocumentTermMatrix", "dtm", "DTM" 
mean "DocumentTermMatrix"; "TermDocumentMatrix", "tdm", "TDM" 
mean "TermDocumentMatrix".}

\item{keep_name}{whether to keep names or 
dimnames, which are, for dtm-like object, 
documents and terms. \code{TRUE} by default. 
If you set it to \code{FALSE}, 
you will lose them. But if you convert dgCMatrix to 
dtm or tdm, it is required that the dgCMatrix object
has a list of length 2 as dimnames.}
}
\value{
the object whose class is specified by argument \code{to}.
}
\description{
This is to convert objects conveniently. The three types of matrix are 
1st, "matrix"; 2nd, "dgCMatrix" in package Matrix; 3rd, 
"simple_triplet_matrix", "DocumentTermMatrix", "TermDocumentMatrix" 
in package slam, tm. 
This function is to be used when you read a csv file and 
want it to be a dtm; or, when you have a very large dtm and you want 
it to be saved or passed to another function that deals with
dgCMatrix object. Note, it cannot convert between simple_triplet_matrix
on one side, and dtm or tdm on the other.
}
\examples{
# Make a matrix and convert to a dtm
m <- sample(0: 1, 50, replace = TRUE)
m <- matrix(m, nrow = 5)
colnames(m) <- letters[1: 10]
rownames(m) <- as.character(1: 5)
dtm <- m3m(m, "dtm")
# Convert dtm to dgCMatrix
M <- m3m(dtm, "M")
}
