% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-compatible-lengths.R
\name{chk_compatible_lengths}
\alias{chk_compatible_lengths}
\alias{vld_compatible_lengths}
\title{Check Compatible Lengths}
\usage{
chk_compatible_lengths(..., x_name = NULL)

vld_compatible_lengths(...)
}
\arguments{
\item{...}{The objects to check for compatible lengths.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.
}
\description{
Checks objects (including vectors) have lengths that could be 'strictly
recycled'. That is to say they must all be either zero length or the same
length with some of length 1.
}
\details{
This function helps to check vectors could be 'strictly recycled.'
For example the function will error if you had a vector of length 2 and
length 4, even though the vector of length 2 could be 'loosely recycled' to
match up to the vector of length 4 when combined.

The intent of the function is to check that only strict recycling is
occurring.
}
\section{Functions}{
\itemize{
\item \code{vld_compatible_lengths()}: Validate Compatible Lengths

}}
\examples{
# chk_compatible_lengths

a <- integer(0)
b <- numeric(0)
chk_compatible_lengths(a, b)

a <- 1
b <- 2
chk_compatible_lengths(a, b)

a <- 1:3
b <- 1:3
chk_compatible_lengths(a, b)

b <- 1
chk_compatible_lengths(a, b)

b <- 1:2
try(chk_compatible_lengths(a, b))

b <- 1:6
try(chk_compatible_lengths(a, b))
# vld_compatible_lengths

a <- integer(0)
b <- numeric(0)
vld_compatible_lengths(a, b)

a <- 1
b <- 2
vld_compatible_lengths(a, b)

a <- 1:3
b <- 1:3
vld_compatible_lengths(a, b)

b <- 1
vld_compatible_lengths(a, b)

b <- 1:2
vld_compatible_lengths(a, b)

b <- 1:6
vld_compatible_lengths(a, b)
}
