% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmas2017trees.R
\name{xmas2017trees}
\alias{xmas2017trees}
\title{Christmas card 2017.}
\usage{
xmas2017trees(year = 2018, language = c("english", "spanish",
  "catalan"), shape = c("piramidal", "oval", "vshaped", "round",
  "columnar"), nballs = 15, ballscolor = NULL, seed = NULL)
}
\arguments{
\item{year}{Year to be printed. Default is \code{2018}.}

\item{language}{Language to be used in the card. One of \code{c("english", "spanish", "catalan")}. Default is \code{"english"}.}

\item{shape}{The shape of the tree. One of \code{c("piramidal", "oval", "vshaped", "round", "columnar")}. Default is \code{"piramidal"}.}

\item{nballs}{The number of balls in the tree. Default is 15.}

\item{ballscolor}{The colors to be used for the balls in the tree. It must be a vector with names of colors included in \code{colors()}, or \code{NULL} (default). If \code{NULL}, then colors are randomly selected.}

\item{seed}{Seed for reproducibility of the card. Default is \code{NULL} (no seed).}
}
\value{
A Christmas card plot including a christmas tree.
}
\description{
Christmas card 2017: Christmas trees with different shapes.
}
\examples{
\donttest{
xmas2017trees()
xmas2017trees(shape = "oval", language = "catalan", ballscolor = "blue")
xmas2017trees(shape = "vshaped", nballs = 15, ballscolor = c("sienna2", "yellow2", "tomato"),
              seed = 1111)
xmas2017trees(shape = "round", language = "spanish")
xmas2017trees(shape = "columnar", nballs = 20, ballscolor = "red")
}
}
\author{
Jose Barrera-Gomez.
}
