% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_openchrom.R
\name{call_openchrom}
\alias{call_openchrom}
\title{Parse files with OpenChrom}
\usage{
call_openchrom(
  files,
  path_out,
  format_in,
  export_format = c("csv", "cdf", "mzml", "animl"),
  return_paths = FALSE
)
}
\arguments{
\item{files}{files to parse}

\item{path_out}{directory to export converted files.}

\item{format_in}{Either \code{msd} for mass spectrometry data, \code{csd} for flame ionization data, or \code{wsd} for DAD/UV data.}

\item{export_format}{Either \code{csv}, \code{cdf}, \code{mzml},  \code{animl}.}

\item{return_paths}{Logical. If TRUE, the function will return a character vector of paths to the newly created files.}
}
\value{
If \code{return_paths} is TRUE, the function will return a vector of paths to the newly created files.
If \code{return_paths} is FALSE and \code{export_format} is \code{csv}, the function will return a list
of chromatograms in \code{data.frame} format. Otherwise, it will not return anything.
}
\description{
Writes \code{xml} batch-files and calls OpenChrom file parsers using a
system call to the command-line interface. To use this function
\href{https://lablicate.com/platform/openchrom}{OpenChrom} must be manually installed.
}
\details{
The \code{call_openchrom} works by creating an \code{xml} batchfile and
feeding it to the OpenChrom command-line interface. OpenChrom batchfiles
consist of \code{InputEntries} (the files you want to convert) and \code{
ProcessEntries} (what you want to do to the files). The parsers are organized
into broad categories by detector-type and output format. The detector-types
are \code{msd} (mass selective detectors), \code{csd} (current selective
detectors, such as FID, ECD, NPD), and \code{wsd} (wavelength selective
detectors, such as  DAD, and UV/VIS). Thus, when calling the OpenChrom parsers,
you must select one of these three options for the input format (\code{format_in}).

\strong{Note:} Turning on the OpenChrom command-line will deactivate the graphical
user interface (GUI). Thus, if you wish to continue using the OpenChrom GUI,
it is recommended to create a separate command-line version of OpenChrom to
call from R.
}
\section{Side effects}{
 Chromatograms will be exported in the format specified
by \code{export_format} in the folder specified by \code{path_out}.
}

\author{
Ethan Bass
}
