% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_thermoraw.R
\name{read_thermoraw}
\alias{read_thermoraw}
\title{Read ThermoRaw files into R using ThermoRawFileParser}
\usage{
read_thermoraw(
  path_in,
  path_out,
  format_out = c("matrix", "data.frame"),
  read_metadata = TRUE
)
}
\arguments{
\item{path_in}{path to file}

\item{path_out}{directory to export \code{mzML} files.}

\item{format_out}{R format. Either \code{matrix} or \code{data.frame}.}

\item{read_metadata}{Whether to read metadata from file.}
}
\value{
A chromatogram in the format specified by \code{format_out}.
}
\description{
Converts ThermoRawFiles to mzmL by calling the ThermoRawFileParser from the
command-line.
}
\details{
To use this function, the \href{https://github.com/compomics/ThermoRawFileParser}{ThermoRawFileParser}
must be manually installed.
}
\section{Side effects}{
 Exports chromatograms in \code{mzml format} to the
folder specified by \code{path_out}.
}

\examples{
\dontrun{
read_thermoraw(path)
}
}
\references{
Hulstaert Niels, Jim Shofstahl, Timo Sachsenberg, Mathias Walzer,
Harald Barsnes, Lennart Martens, and Yasset Perez-Riverol.
“=ThermoRawFileParser: Modular, Scalable, and Cross-Platform RAW File Conversion.”
\emph{Journal of Proteome Research} \bold{19}, no. 1 (January 3, 2020): 537–42.
\doi{10.1021/acs.jproteome.9b00328}.
}
\author{
Ethan Bass
}
