% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chromoMap.R
\name{chromoMap}
\alias{chromoMap}
\title{render interactive chromosome plots of any living organism and annotate elements}
\usage{
chromoMap(
  ch.files,
  data.files,
  title = c(),
  ch_gap = 5,
  ploidy = 1,
  top_margin = 25,
  left_margin = 50,
  chr_width = 15,
  chr_length = 4,
  chr_color = c("black"),
  data_based_color_map = FALSE,
  segment_annotation = FALSE,
  lg_x = 0,
  lg_y = 0,
  data_type = c("numeric", "categorical"),
  labels = FALSE,
  canvas_width = NULL,
  canvas_height = NULL,
  data_colors = list(),
  anno_col = c("#10B85F"),
  chr_text = c(TRUE),
  discrete.domain = NULL,
  legend = c(FALSE),
  hlinks = FALSE,
  aggregate_func = c("avg"),
  plots = c("none"),
  tag_filter = list(c("none", 0)),
  plot_height = c(30),
  plot_ticks = c(4),
  plot_color = c("blue"),
  plot_y_domain = list(c(0, 0)),
  ch2D.colors = NULL,
  ch2D.cat.order = NULL,
  ch2D.lg_x = 0,
  ch2D.lg_y = 0,
  ref_line = c(FALSE),
  refl_pos = c(0),
  refl_color = c("grey"),
  refl_stroke_w = c(2),
  tagColor = c("red"),
  heat_map = c(TRUE),
  text_font_size = c(10),
  chr_curve = 5,
  title_font_size = 12,
  label_font = 9,
  label_angle = -90,
  vertical_grid = FALSE,
  grid_array = c(0, 5000, 10000),
  grid_color = "grey",
  grid_text = NULL,
  grid_text_size = 12,
  grid_text_y = 20,
  plot_filter = list(c("none", 0)),
  id = c("chromap"),
  region = NULL,
  show.links = FALSE,
  loci_links = "none",
  directed.edges = F,
  y_chr_scale = 0,
  links.colors = NULL,
  links.lg_x = 0,
  links.lg_y = 0,
  n_win.factor = 1,
  chr.scale.ticks = 5,
  export.options = F,
  fixed.window = F,
  window.size = NULL,
  win.summary.display = F,
  remove.last.window = T,
  guides = F,
  guides_color = "lightgrey",
  ann.h = 1,
  chr.2D.plot = F,
  display.chr = T,
  plot.shift = c(1),
  plot.legend.labels = c(""),
  cat.legend.label = "",
  plot.y.labels = c(""),
  plot.y.lab.x = 10,
  plot.y.lab.y = 0,
  plot.y.lab.size = 15,
  scale.suffix = "bp",
  numeric.domain = NULL,
  interactivity = T
)
}
\arguments{
\item{ch.files}{filename(s) as character vector OR list of data.frames containing co-ordinates of the chromosomes to render}

\item{data.files}{filename(s) as character vector OR list of data.frames containing data to annotate on the chromosomes.}

\item{title}{a character string to be used as a title in plot}

\item{ch_gap}{provide spacing between chromosomes.}

\item{ploidy}{specify the number of sets of chromsomes being passed.}

\item{top_margin}{specify the margin from top of the plot}

\item{left_margin}{specify the margin from the left of the plot}

\item{chr_width}{specify the width of each chromsome}

\item{chr_length}{specify the length of each chromsome.}

\item{chr_color}{a vector specifying the color of each chromsome in a set. A color
can be assigned to each set by passing a different color values as vector}

\item{data_based_color_map}{a boolean to tell the plot to use the data provided in file for
visualizing annotation}

\item{segment_annotation}{a boolean to use segment-annotation algorithm}

\item{lg_x}{specify the x or horizontal distance of the legend from origin(bottom right corner)}

\item{lg_y}{specify the y or vertical distnce of the legend from the origin}

\item{data_type}{specifying the data type of the data used. takes value either 'categorical' or
'numeric'}

\item{labels}{a boolean to include labels in plot}

\item{canvas_width}{width of the plot}

\item{canvas_height}{height of the plot}

\item{data_colors}{specify annotation colors for the data}

\item{anno_col}{a vector to specify annotation color for each set.}

\item{chr_text}{a boolean vector to enable or disable chromsome texts for each ploidy.set}

\item{discrete.domain}{manually specify the order of categories.}

\item{legend}{a boolean vector to enable or disable legend for each set/ploidy}

\item{hlinks}{a boolean to use hyperlinks supplied in data}

\item{aggregate_func}{takes either 'sum' or 'avg' to specift aggregate function for each loci}

\item{plots}{specify the type of plot to visualize. takes either 'scatter' , 'bar' or 'tags'.(default: 'none')}

\item{tag_filter}{a list to specify the filter operation and operands for each ploidy.}

\item{plot_height}{specify plot height for each ploidy. default: c(30)}

\item{plot_ticks}{specify number of ticks for plot axis. default: c(4)}

\item{plot_color}{specify the plot color for each ploidy. default: c("blue")}

\item{plot_y_domain}{specify plot y-axis domain. default: list(c(0,0))}

\item{ch2D.colors}{specify the group colors for visualizing categories on 2D chromosome plots}

\item{ch2D.cat.order}{manually setting the order of categories for 2D-Chromsome plot}

\item{ch2D.lg_x}{specify the x or horizontal distance of 2D plot legend from the origin(bottom right corner)}

\item{ch2D.lg_y}{specify the y or vertical distance of 2D plot legend}

\item{ref_line}{a boolean to use horizontal reference line in plot. default: c(FALSE)}

\item{refl_pos}{specify the position of reference line. default: c(0)}

\item{refl_color}{specify the color of the reference line. default: c("grey")}

\item{refl_stroke_w}{specify the stroke width of the reference line. default: c(2)}

\item{tagColor}{specify the color of tags. default: c("red")}

\item{heat_map}{a boolean to use if chromosome heatmaps are shown. default: c(TRUE),}

\item{text_font_size}{specify chromosome text font-size. default: c(10)}

\item{chr_curve}{specify the chromosome curves at the telomeres or centromere loci. default:5}

\item{title_font_size}{specify the font-size of the title. default:12}

\item{label_font}{specify the font-size of the labels. default:9}

\item{label_angle}{specify the angle of rotation of labels. default: -90}

\item{vertical_grid}{a boolean to use vertical grid lines. default: FALSE}

\item{grid_array}{specify the position(s) of grid line(s) in bp to highlight locations across genome. default: c(0,5000,10000)}

\item{grid_color}{specify the color of the grid lines. default: "grey"}

\item{grid_text}{specify the text to be attached at the top end of gridlines}

\item{grid_text_size}{specify the font-size of the text}

\item{grid_text_y}{specify the y-distance (from top) for the text}

\item{plot_filter}{a list specify the plot filter operation, operands, and filter-color for each ploidy.}

\item{id}{specify a unique id doe chromoMap plot. default: c("chromap")}

\item{region}{specify the region of interest for chromosome(s) for zoom-in. Format: "chrName:Ploidy:Start:Stop"}

\item{show.links}{a boolean to specify whether links are visualized. default: FALSE}

\item{loci_links}{a character vector specifying file name or a data.frame for links input data}

\item{directed.edges}{a boolean to visualize directed edges}

\item{y_chr_scale}{adjust the chromosome scale along y-axis}

\item{links.colors}{specify the links colors}

\item{links.lg_x}{specify x or horizontal distance of links legend from the origin}

\item{links.lg_y}{specify y or vertical distance of links}

\item{n_win.factor}{specify the factor by which the chr will be scaled;increases number of windows (default:1)}

\item{chr.scale.ticks}{specify the number of ticks for chr scale (default:5)}

\item{export.options}{boolean to include export buttons in the plot}

\item{fixed.window}{Boolean to specify wether to use fixed window visualization}

\item{window.size}{specify the window size, if fixed.window is TRUE}

\item{win.summary.display}{boolean to display window summary to console}

\item{remove.last.window}{For fixed window analysis, boolean to specify whether to include last window of chromosomes}

\item{guides}{boolean to display guides}

\item{guides_color}{set guides color.}

\item{ann.h}{set annotation bar height in 2D-Chromosome plot}

\item{chr.2D.plot}{boolean to specify visualize 2d Chromosome plot}

\item{display.chr}{boolean to show.hide chromosome}

\item{plot.shift}{shifting the plots in y direction in case hiding chromosomes}

\item{plot.legend.labels}{specify plot legend labels}

\item{cat.legend.label}{specify categorical-data legends label}

\item{plot.y.labels}{specify plots y-axis labels}

\item{plot.y.lab.x}{adjust plot y labels in x-direction}

\item{plot.y.lab.y}{adjust plot y labels in y-direction}

\item{plot.y.lab.size}{set size of plot y labels}

\item{scale.suffix}{set the suffix for chromosome scale(default:'bp')}

\item{numeric.domain}{manually set data domain(min,max) for heat colors for numeric data}

\item{interactivity}{boolean to enable/disable interactivity on chromosomes}
}
\description{
render an interactive graphics visualization of entire chromosomes
 or chromosomal regions of any living organism. Chromosomal elements such as genes 
 can be annotated easily using this tool.

required for creating widgets
}
\examples{
\dontrun{

library(chromoMap)

#simple annotations
chromoMap("chromosome_file.txt","annotation_file.txt")

#polyploidy example
chromoMap(c("chromosome_set1.txt","chromosome_set2.txt"),
          c("annotation_set1.txt","annotation_set2.txt"), ploidy=2)

#plotting group annotation
chromoMap("chromosome_file.txt","annotation_file.txt",
           data_base_color_map=T, data_type="categorical")

#plotting chromsome heatmaps
chromoMap("chromosome_file.txt","annotation_file.txt",
           data_based_color_map=T, data_type="numeric")

#enabling hyperlinks
chromoMap("chromosome_file.txt","annotation_file.txt", hlinks=T)

#enabling labels
chromoMap("chromosome_file.txt","annotation_file.txt", labels=T)

#change chromosome color
chromoMap("chromosome_file.txt","annotation_file.txt", chr_color="red")

}





}
