% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_columns.R
\name{report_columns}
\alias{report_columns}
\title{HTML interactive report detailing each column on a table}
\usage{
report_columns(
  dt,
  by_column = NULL,
  filename = NULL,
  output_format = "prettydoc",
  author = "chronicle user",
  horizontal_bars = FALSE,
  sort_bars_value = FALSE,
  sort_bars_decreasingly = TRUE,
  prettydoc_theme = "leonids",
  highlight = "github",
  number_sections = TRUE,
  table_of_content = TRUE,
  table_of_content_depth = 1,
  fig_width = 11,
  fig_height = 5,
  directory = getwd(),
  keep_rmd = FALSE,
  render_html = TRUE
)
}
\arguments{
\item{dt}{Table to be plotted.}

\item{by_column}{Name of the column to use as groups for all the other plots}

\item{filename}{Name of the output file.}

\item{output_format}{The format of the R Markdown file. Default is prettydoc. Currently supported: 'prettydoc', 'ioslides', 'tufte', 'flexdashboard', 'slidy_presentation', 'html_document' and 'html_notebook'.}

\item{author}{Author of the report.}

\item{horizontal_bars}{Plot bars for categorical variables horizontally. Default is FALSE}

\item{sort_bars_value}{Sort the bars by value. Default is FALSE.}

\item{sort_bars_decreasingly}{Sort the bars decreasingly. Default is TRUE.}

\item{prettydoc_theme}{Name of the theme used on prettydoc. Default is leonids.}

\item{highlight}{Rmarkdown highlight theming. Default is github highlighting.}

\item{number_sections}{Whether or not to number the sections and subsections fo the report.}

\item{table_of_content}{Whether or not to include a table fo content at the beginning of the report.}

\item{table_of_content_depth}{The depth of sections and subsections to be displayed on the table of content.}

\item{fig_width}{Set the global figure width or the rmarkdown file.}

\item{fig_height}{Set the global figure height or the rmarkdown file.}

\item{directory}{The directory in which to render the .html report}

\item{keep_rmd}{Whether or not to keep the .Rmd file. Default is false.}

\item{render_html}{Whether or not to render the report as an interactive hmtl file.}
}
\value{
Creates an HTML file with a plot for each column on the given table: a box plot for each numerical variable, and a bar plot for each categorical variable.
}
\description{
Creates an Rmarkdown report plotting each column of a dataset.
Categorical columns are plotted in bar plots, and numerical
columns are plotted in box plots. If 'by_column' is provided,
these plots will be grouped by the values of that column
}
\examples{
# chronicle::report_columns(dt = iris,
#                           by_column = 'Species',
#                           horizontal_bars = TRUE,
#                           keep_rmd = TRUE)
# file.remove('iris_column_analysis.Rmd')
# file.remove('iris_column_analysis.html')
}
