% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_probs_negbin.R
\name{add_probs.negbin}
\alias{add_probs.negbin}
\title{Response Probabilities for Negative Binomial Models}
\usage{
\method{add_probs}{negbin}(tb, fit, q, name = NULL, yhatName = "pred",
  comparison = "<", nSims = 2000, ...)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class \code{negbin}. Predictions are made
with this object.}

\item{q}{A double. A quantile of the response distribution.}

\item{name}{\code{NULL} or a string. If \code{NULL}, probabilities
automatically will be named by \code{add_probs()}, otherwise,
the probabilities will be named \code{name} in the returned
tibble}

\item{yhatName}{A string. Name of the vector of predictions.}

\item{comparison}{A character vector of length one. Permitted
arguments are \code{"="}, \code{"<"}, \code{"<="}, \code{">"}, or
\code{">="}. The default value is \code{"<"}.}

\item{nSims}{A positive integer. Controls the number of simulated
draws.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted values and
    probabilities attached.
}
\description{
This is the method \code{add_probs} uses if the model fit is an
object of class \code{negbin}. Probabilities are determined through
simulation, using the same method as \code{add_pi.negbin}.
}
\examples{
x1 <- rnorm(100, mean = 1)
y <- MASS::rnegbin(n = 100, mu = exp(1 + x1), theta = 5)
df <- data.frame(x1 = x1, y = y)
fit <- MASS::glm.nb(y ~ x1, data = df)
add_probs(df, fit, q = 50)

}
\seealso{
\code{\link{add_ci.negbin}} for confidence intervals for
    \code{negbin} objects, \code{\link{add_pi.negbin}} for prediction
    intervals of \code{negbin} objects, and
    \code{\link{add_quantile.negbin}} for response quantiles of
    \code{negbin} objects.
}
