% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pi_survreg.R
\name{add_pi.survreg}
\alias{add_pi.survreg}
\title{Prediction Intervals for Accelerated Failure Time Models}
\usage{
\method{add_pi}{survreg}(tb, fit, alpha = 0.05, names = NULL,
  yhatName = "median_pred", nSims = 10000, method = "naive", ...)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class \code{survreg}.}

\item{alpha}{A real number between 0 and 1. Controls the confidence
level of the interval estimates.}

\item{names}{\code{NULL} or character vector of length two. If
\code{NULL}, prediction bounds automatically will be named by
\code{add_pi}, otherwise, the lower prediction bound will be
named \code{names[1]} and the upper prediction bound will be
named \code{names[2]}.}

\item{yhatName}{A string. Name of the predictions vector.}

\item{nSims}{A positive integer. Determines the number of bootstrap
replicates if \code{method = "boot"}.}

\item{method}{A string. Determines the method used to calculate
prediction intervals. Must be one of either \code{"naive"} or
\code{"boot"}.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted medians, upper and lower
    prediction bounds attached.
}
\description{
This function is one of the methods for \code{add_pi}, and is
called automatically when \code{add_pi} is used on a \code{fit} of
class \code{survreg}.
}
\details{
\code{add_pi.survreg} creates prediction intervals for the survival
time $T$ conditioned on the covariates of the \code{survreg}
model. In simple terms, this function calculates error bounds
within which one can expect to observe a new survival time. Like
other parametric survival methods in \code{ciTools}, prediction
intervals are limited to unweighted lognormal, exponential,
weibull, and loglogistic AFT models.

Two methods are available for creating prediction intervals, the
"naive" method (Meeker and Escobar, chapter 8) and a simulation
method that implements a parametric bootstrap routine. The "naive"
method calculates quantiles of the fitted survival time
distribution to determine prediction intervals. The parametric
bootstrap method simulates new survival times from the conditional
survival time distribution, taking into account the uncertainty in
the regression coefficients. The bootstrap method is similar to the
one implemented in \code{add_pi.glm}.

Note: Due to a limitation, the \code{Surv} object must be specified in
\code{survreg} function call. See the examples section for one way
to do this.

Note: \code{add_pi.survreg} cannot inspect the convergence of
\code{fit}. Poor maximum likelihood estimates will result in poor
prediction intervals. Inspect any warning messages given from
\code{survreg}.
}
\examples{
## Define a data set.
tb <- survival::stanford2
## remove a covariate with missing values.
tb <- tb[, 1:4]
## next, create the Surv object inside the survreg call:
fit <- survival::survreg(survival::Surv(time, status) ~ age + I(age^2),
                         data = tb, dist = "lognormal")
add_pi(tb, fit, alpha = 0.1, names = c("lwr", "upr"))

## Try a different model:
fit2 <- survival::survreg(survival::Surv(time, status) ~ age + I(age^2),
                          data = tb, dist = "weibull")
add_pi(tb, fit2, alpha = 0.1, names = c("lwr", "upr"))

}
\references{
For a discussion prediction intervals of accelerated failure time models:
Meeker, William Q., and Luis A. Escobar. Statistical methods for reliability data. John Wiley & Sons, 2014. (Chapter 8)
}
\seealso{
\code{\link{add_ci.survreg}} for confidence intervals for
    \code{survreg} objects, \code{\link{add_probs.survreg}} for
    conditional survival probabilities of \code{survreg} objects, and
    \code{\link{add_quantile.survreg}} for survival time quantiles
    of \code{survreg} objects.
}
