% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{match_exactly}
\alias{match_exactly}
\title{Do these character vectors match exactly?}
\usage{
match_exactly(
  user,
  expected,
  fail_action = c("message", "warning", "stop", "nothing")
)
}
\arguments{
\item{user}{Character vector of user input.}

\item{expected}{Character vector of expected/allowed values.}

\item{fail_action}{If any value in \code{user} could not be
matched, or repeated matches occured, what should happen? Possible values
are \code{"message"} (default), \code{"warning"}, \code{"stop"}, and
\code{"nothing"}.}
}
\value{
Logical. Do \code{user} and \code{expected} match?
}
\description{
Checks if a user-defined character vector matches an expected character
 vector. That is, they share the same lengths and entries in the same order.
 For vectors of the same lengths, the result is \code{all(a == b)}.
}
\details{
Attributes are ignored.
}
\keyword{internal}
