% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_cifti.R
\name{write_cifti}
\alias{write_cifti}
\alias{writeCIfTI}
\alias{writecii}
\alias{write_xifti}
\title{Write a CIFTI file from a \code{"xifti"} object}
\usage{
write_cifti(
  xifti,
  cifti_fname,
  surfL_fname = NULL,
  surfR_fname = NULL,
  verbose = TRUE
)

writeCIfTI(
  xifti,
  cifti_fname,
  surfL_fname = NULL,
  surfR_fname = NULL,
  verbose = TRUE
)

writecii(
  xifti,
  cifti_fname,
  surfL_fname = NULL,
  surfR_fname = NULL,
  verbose = TRUE
)

write_xifti(
  xifti,
  cifti_fname,
  surfL_fname = NULL,
  surfR_fname = NULL,
  verbose = TRUE
)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{cifti_fname}{File path to a CIFTI file (ending in ".d*.nii").}

\item{surfL_fname, surfR_fname}{If the [left/right] surface is present, it
will be a written to a GIFTI file at this file path. If \code{NULL}
(default), do not write out the surface.}

\item{verbose}{Should occasional updates be printed? Default: \code{TRUE}.}
}
\value{
Named character vector of the written files
}
\description{
Write out a \code{"xifti"} object as a CIFTI file and (optionally) GIFTI
surface files.
}
\details{
See \code{\link{write_xifti2}} to write a \code{"xifti"} object out as
separate GIFTI and/or NIFTI files instead.
}
\section{Connectome Workbench}{

This function interfaces with the \code{"-cifti-create-dense-timeseries"},
\code{"-cifti-create-dense-scalar"}, or \code{"-cifti-create-label"} Workbench
Command, depending on the input.
}

\seealso{
Other common: 
\code{\link{is.cifti}()},
\code{\link{read_cifti}()},
\code{\link{resample_cifti}()},
\code{\link{smooth_cifti}()},
\code{\link{view_xifti}()}

Other writing: 
\code{\link{separate_cifti}()},
\code{\link{write_metric_gifti}()},
\code{\link{write_subcort_nifti}()},
\code{\link{write_surf_gifti}()},
\code{\link{write_xifti2}()}
}
\concept{common}
\concept{writing}
