% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_surf.R
\name{add_surf}
\alias{add_surf}
\title{Add surface(s) to a \code{"xifti"}}
\usage{
add_surf(xifti, surfL = NULL, surfR = NULL)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{surfL}{(Optional) Left brain surface model. Can be a file
path to a GIFTI surface geometry file (ends in "*.surf.gii"), a
\code{"gifti"} object representing surface geometry, or a \code{"surf"}
object.}

\item{surfR}{(Optional) Right brain surface model. Can be a file
path to a GIFTI surface geometry file (ends in "*.surf.gii"), a
\code{"gifti"} object representing surface geometry, or a \code{"surf"}
object.}
}
\value{
the \code{"xifti"} object with added surface geometry components.
}
\description{
Add left or right cortical surface geometry to a \code{"xifti"} object.
}
\details{
\code{surfL} will be added to \code{xifti$surf$cortex_left} and \code{surfR}
will be added to \code{xifti$surf$cortex_right}. Any existing surfaces will
be overwritten.

If the resolutions of the data and surfaces do not match, the surfaces will
be resampled to match the resolution of the data. The barycentric resampling
method, which is recommended for anatomical surfaces, will be used.
}
\seealso{
Other manipulating xifti: 
\code{\link{apply_parc}()},
\code{\link{apply_xifti}()},
\code{\link{combine_xifti}()},
\code{\link{convert_to_dlabel}()},
\code{\link{merge_xifti}()},
\code{\link{move_to_mwall}()},
\code{\link{newdata_xifti}()},
\code{\link{remap_cifti}()},
\code{\link{remove_xifti}()},
\code{\link{resample_cifti}()},
\code{\link{resample_cifti_from_template}()},
\code{\link{scale_xifti}()},
\code{\link{select_xifti}()},
\code{\link{set_names_xifti}()},
\code{\link{smooth_cifti}()},
\code{\link{transform_xifti}()}

Other surface-related: 
\code{\link{boundary_mask_surf}()},
\code{\link{edit_mask_surf}()},
\code{\link{even_vert_samp}()},
\code{\link{is.surf}()},
\code{\link{load_surf}()},
\code{\link{mask_surf}()},
\code{\link{read_surf}()},
\code{\link{resample_surf}()},
\code{\link{rotate_surf}()},
\code{\link{surf_area}()},
\code{\link{view_surf}()},
\code{\link{write_surf_gifti}()}
}
\concept{manipulating xifti}
\concept{surface-related}
