% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cinaR.R
\name{filterConsensus}
\alias{filterConsensus}
\title{filterConsensus}
\usage{
filterConsensus(
  cp,
  filter.method = "custom",
  library.threshold = 2,
  cpm.threshold = 1
)
}
\arguments{
\item{cp}{consensus peak matrix, with unique ids at rownames.}

\item{filter.method}{filtering method for low expressed peaks}

\item{library.threshold}{number of libraries a peak occurs so that it is not filtered default set to 2}

\item{cpm.threshold}{count per million threshold for not to filter a peak}
}
\value{
returns differentially accessible peaks
}
\description{
Filters lowly expressed peaks from down-stream analyses
}
\examples{
set.seed(123)
cp <- matrix(rexp(200, rate=.1), ncol=20)

## using cpm function from `edgeR` package
cp.filtered <- filterConsensus(cp)

}
