% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continue_training.R
\name{continue_training}
\alias{continue_training}
\alias{continue_training.citodnn}
\alias{continue_training.citodnnBootstrap}
\title{Continues training of a model generated with \code{\link{dnn}} for additional epochs.}
\usage{
continue_training(
  model,
  epochs = 32,
  data = NULL,
  device = "cpu",
  verbose = TRUE,
  changed_params = NULL,
  parallel = FALSE
)

\method{continue_training}{citodnn}(
  model,
  epochs = 32,
  data = NULL,
  device = "cpu",
  verbose = TRUE,
  changed_params = NULL,
  parallel = FALSE
)

\method{continue_training}{citodnnBootstrap}(
  model,
  epochs = 32,
  data = NULL,
  device = "cpu",
  verbose = TRUE,
  changed_params = NULL,
  parallel = FALSE
)
}
\arguments{
\item{model}{a model created by \code{\link{dnn}}}

\item{epochs}{additional epochs the training should continue for}

\item{data}{matrix or data.frame if not provided data from original training will be used}

\item{device}{device on which network should be trained on, either "cpu" or "cuda"}

\item{verbose}{print training and validation loss of epochs}

\item{changed_params}{list of arguments to change compared to original training setup, see \code{\link{dnn}} which parameter can be changed}

\item{parallel}{train bootstrapped model in parallel}
}
\value{
a model of class citodnn or citodnnBootstrap created by  \code{\link{dnn}}
}
\description{
If the training/validation loss is still decreasing at the end of the training, it is often a sign that the NN has not yet converged. You can use this function to continue training instead of re-training the entire model.
}
\examples{
\donttest{
if(torch::torch_is_installed()){
library(cito)

set.seed(222)
validation_set<- sample(c(1:nrow(datasets::iris)),25)

# Build and train  Network
nn.fit<- dnn(Sepal.Length~., data = datasets::iris[-validation_set,], epochs = 32)

# continue training for another 32 epochs
nn.fit<- continue_training(nn.fit,epochs = 32)

# Use model on validation set
predictions <- predict(nn.fit, iris[validation_set,])
}
}
}
