% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{notebooks_post}
\alias{notebooks_post}
\title{Create a Notebook}
\usage{
notebooks_post(name = NULL, language = NULL, description = NULL,
  file_id = NULL, requirements_file_id = NULL, requirements = NULL,
  docker_image_name = NULL, docker_image_tag = NULL, instance_type = NULL,
  memory = NULL, cpu = NULL, credentials = NULL,
  environment_variables = NULL, idle_timeout = NULL, git_repo_url = NULL,
  git_ref = NULL, git_path = NULL, hidden = NULL)
}
\arguments{
\item{name}{string optional. The name of this notebook.}

\item{language}{string optional. The kernel language of this notebook.}

\item{description}{string optional. The description of this notebook.}

\item{file_id}{string optional. The file ID for the S3 file containing the .ipynb file.}

\item{requirements_file_id}{string optional. The file ID for the S3 file containing the requirements.txt file.}

\item{requirements}{string optional. The requirements txt file.}

\item{docker_image_name}{string optional. The name of the docker image to pull from DockerHub.}

\item{docker_image_tag}{string optional. The tag of the docker image to pull from DockerHub (default: latest).}

\item{instance_type}{string optional. The EC2 instance type to deploy to.}

\item{memory}{integer optional. The amount of memory allocated to the notebook.}

\item{cpu}{integer optional. The amount of cpu allocated to the the notebook.}

\item{credentials}{array optional. A list of credential IDs to pass to the notebook.}

\item{environment_variables}{object optional. Environment variables to be passed into the Notebook.}

\item{idle_timeout}{integer optional. How long the notebook will stay alive without any kernel activity.}

\item{git_repo_url}{string optional. The url of the git repository}

\item{git_ref}{string optional. The git reference if git repo is specified}

\item{git_path}{string optional. The path to the .ipynb file in the git repo that will be started up on notebook launch}

\item{hidden}{boolean optional. The hidden status of the object.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for this notebook.}
\item{name}{string, The name of this notebook.}
\item{language}{string, The kernel language of this notebook.}
\item{description}{string, The description of this notebook.}
\item{notebookUrl}{string, Time-limited URL to get the .ipynb file for this notebook.}
\item{notebookPreviewUrl}{string, Time-limited URL to get the .htm preview file for this notebook.}
\item{requirementsUrl}{string, Time-limited URL to get the requirements.txt file for this notebook.}
\item{fileId}{string, The file ID for the S3 file containing the .ipynb file.}
\item{requirementsFileId}{string, The file ID for the S3 file containing the requirements.txt file.}
\item{user}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{dockerImageName}{string, The name of the docker image to pull from DockerHub.}
\item{dockerImageTag}{string, The tag of the docker image to pull from DockerHub (default: latest).}
\item{instanceType}{string, The EC2 instance type to deploy to.}
\item{memory}{integer, The amount of memory allocated to the notebook.}
\item{cpu}{integer, The amount of cpu allocated to the the notebook.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{mostRecentDeployment}{object, A list containing the following elements: 
\itemize{
\item deploymentId integer, The ID for this deployment.
\item userId integer, The ID of the owner.
\item host string, Domain of the deployment.
\item name string, Name of the deployment.
\item dockerImageName string, The name of the docker image to pull from DockerHub.
\item dockerImageTag string, The tag of the docker image to pull from DockerHub (default: latest).
\item displayUrl string, URL that displays the deployed platform object and includes auth token.
\item instanceType string, The EC2 instance type requested for the deployment.
\item memory integer, The memory allocated to the deployment.
\item cpu integer, The cpu allocated to the deployment.
\item state string, The state of the deployment.
\item stateMessage string, A detailed description of the state.
\item createdAt string, 
\item updatedAt string, 
\item published boolean, 
\item notebookId integer, The ID of owning Notebook
}}
\item{credentials}{array, A list of credential IDs to pass to the notebook.}
\item{environmentVariables}{object, Environment variables to be passed into the Notebook.}
\item{idleTimeout}{integer, How long the notebook will stay alive without any kernel activity.}
\item{gitRepoId}{integer, The ID of the git repository.}
\item{gitRepoUrl}{string, The url of the git repository}
\item{gitRef}{string, The git reference if git repo is specified}
\item{gitPath}{string, The path to the .ipynb file in the git repo that will be started up on notebook launch}
\item{archived}{string, The archival status of the requested object(s).}
\item{hidden}{boolean, The hidden status of the object.}
}
\description{
Create a Notebook
}
