% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{apps_get_instances}
\alias{apps_get_instances}
\title{Return a given app instance}
\usage{
apps_get_instances(id, slug)
}
\arguments{
\item{id}{integer required. The unique id of the instance.}

\item{slug}{string required. The slug for the application.}
}
\value{
A list containing the following elements:
\item{id}{integer, The unique id of the instance.}
\item{name}{string, The name of the instance.}
\item{appReleaseId}{integer, The id of the app release the instance belongs to.}
\item{reportId}{integer, The id of the report the instance belongs to.}
\item{createdAt}{string, The time the instance was created at.}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{projectId}{integer, The id of the project collecting all the items that belong to this app instance.}
\item{authCodeUrl}{string, }
\item{apiKey}{string, A Civis API key that can be used by this app instance.}
}
\description{
Return a given app instance
}
