% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{media_patch_optimizations}
\alias{media_patch_optimizations}
\title{Edit an existing optimization}
\usage{
media_patch_optimizations(id, name = NULL, runs = NULL, programs = NULL,
  networks = NULL, exclude_programs = NULL, exclude_networks = NULL,
  time_slot_percentages = NULL)
}
\arguments{
\item{id}{integer required. The optimization ID.}

\item{name}{string optional. The name of the optimization.}

\item{runs}{array optional. An array containing the following fields: 
\itemize{
\item marketId integer, The market ID.
\item startDate string, The start date for the media run.
\item endDate string, The end date for the media run.
\item forceCpm boolean, Whether to force optimization to use CPM data even if partition data is available.
\item reachAlpha number, A tuning parameter used to adjust RF.
\item syscodes array, The syscodes for the media run.
\item rateCards array, The ratecards for the media run.
\item constraints array, The constraints for the media run.
}}

\item{programs}{array optional. An array of programs that the Civis Media Optimizer either exclude or limit to.An error will be thrown if exclude_programs is not also set.}

\item{networks}{array optional. An array of networks that the Civis Media Optimizer either exclude or limit to.An error will be thrown if exclude_networks is not also set.}

\item{exclude_programs}{boolean optional. If Civis Media Optimizer should exclude the programs in the programs parameter.If this value is set to false, it will make the optimization limit itself to the programs supplied through the programs parameter.An error will be thrown if programs is not also set.}

\item{exclude_networks}{boolean optional. If Civis Media Optimizer should exclude the networks in the networks parameter.If this value is set to false, it will make the optimization limit itself to the networks supplied through the networks.An error will be thrown if networks is not also set.}

\item{time_slot_percentages}{list optional. The maximum amount of the budget spent on that particular day of the week, daypart, or specific time slot for broadcast and cable.}
}
\value{
A list containing the following elements:
\item{id}{integer, The optimization ID.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{name}{string, The name of the optimization.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{finishedAt}{string, The end time of the last run.}
\item{state}{string, The state of the last run.}
\item{lastRunId}{integer, The ID of the last run.}
\item{spotOrderId}{integer, The ID for the spot order produced by the optimization.}
\item{archived}{string, The archival status of the requested item(s).}
\item{reportLink}{string, A link to the visual report for the optimization.}
\item{spotOrderLink}{string, A link to the json version of the spot order.}
\item{fileLinks}{array, Links to the csv and xml versions of the spot order.}
\item{runs}{array, An array containing the following fields: 
\itemize{
\item marketId integer, The market ID.
\item startDate string, The start date for the media run.
\item endDate string, The end date for the media run.
\item forceCpm boolean, Whether to force optimization to use CPM data even if partition data is available.
\item reachAlpha number, A tuning parameter used to adjust RF.
\item syscodes array, The syscodes for the media run.
\item rateCards array, The ratecards for the media run.
\item constraints array, The constraints for the media run.
}}
\item{programs}{array, An array of programs that the Civis Media Optimizer either exclude or limit to.An error will be thrown if exclude_programs is not also set.}
\item{networks}{array, An array of networks that the Civis Media Optimizer either exclude or limit to.An error will be thrown if exclude_networks is not also set.}
\item{excludePrograms}{boolean, If Civis Media Optimizer should exclude the programs in the programs parameter.If this value is set to false, it will make the optimization limit itself to the programs supplied through the programs parameter.An error will be thrown if programs is not also set.}
\item{excludeNetworks}{boolean, If Civis Media Optimizer should exclude the networks in the networks parameter.If this value is set to false, it will make the optimization limit itself to the networks supplied through the networks.An error will be thrown if networks is not also set.}
\item{timeSlotPercentages}{list, The maximum amount of the budget spent on that particular day of the week, daypart, or specific time slot for broadcast and cable.}
}
\description{
Edit an existing optimization
}
