% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{apps_list_releases}
\alias{apps_list_releases}
\title{List the releases of a particular Decision Application}
\usage{
apps_list_releases(
  slug,
  archived = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{slug}{string required. The slug for the application.}

\item{archived}{string optional. The archival status of the requested item(s).}

\item{limit}{integer optional. Number of results to return. Defaults to its maximum of 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to id. Must be one of: id.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to asc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The unique id of the release.}
\item{appId}{integer, The id of the app the release belongs to.}
\item{reportTemplateId}{integer, ID of the report template for this release.}
\item{resources}{list, A hash of resources associated with this release.}
\item{archived}{string, The archival status of the requested item(s).}
}
\description{
List the releases of a particular Decision Application
}
