% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{query_civis_file}
\alias{query_civis_file}
\alias{query_civis_file.character}
\alias{query_civis_file.sql}
\alias{query_civis_file.numeric}
\title{Export results from a query to S3 and return a file id.}
\usage{
query_civis_file(x, ...)

\method{query_civis_file}{character}(
  x,
  database = NULL,
  job_name = NULL,
  hidden = TRUE,
  verbose = verbose,
  csv_settings = NULL,
  ...
)

\method{query_civis_file}{sql}(
  x,
  database = NULL,
  job_name = NULL,
  hidden = TRUE,
  verbose = FALSE,
  csv_settings = NULL,
  ...
)

\method{query_civis_file}{numeric}(x, database = NULL, verbose = FALSE, ...)
}
\arguments{
\item{x}{"schema.table", \code{sql("query")}, or a sql script job id.}

\item{...}{Options passed to \code{\link{scripts_post_sql}}, including \code{credential}.}

\item{database}{string, Name of database where data frame is to be uploaded.
If no database is specified, uses \code{options(civis.default_db)}.}

\item{job_name}{string, Name of the job (default: \code{"Civis S3 Export Via R Client"}).}

\item{hidden}{bool, Whether the job is hidden.}

\item{verbose}{bool, Set to TRUE to print intermediate progress indicators.}

\item{csv_settings}{See \code{\link{scripts_post_sql}} for details.}
}
\description{
Exports results from a Redshift SQL query, and returns the id of the file on S3 for use
with \code{\link{read_civis}} or \code{\link{download_civis}}.
}
\details{
By default, the export uses the default csv_settings in \code{\link{scripts_post_sql}},
which is a gzipped csv.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Export a \code{"schema.table"} to a file id.

\item \code{sql}: Export results of a query to a file id.

\item \code{numeric}: Run an existing sql script and return the file id of the results on S3.
}}

\examples{
\dontrun{
id <- query_civis_file("schema.tablename", database = "my_database")
df <- read_civis(id, using = read.csv)

query <- sql("SELECT * FROM table JOIN other_table USING id WHERE var1 < 23")
id <- query_civis_file(query)
df <- read_civis(id, using = read.csv)

id <- query_civis_file(query_id, credential_id = 0000)
df <- read_civis(id, using = read.csv)
}
}
\seealso{
Other io: 
\code{\link{download_civis}()},
\code{\link{query_civis}()},
\code{\link{read_civis}()},
\code{\link{write_civis_file}()},
\code{\link{write_civis}()}
}
\concept{io}
