% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{projects_post_clone}
\alias{projects_post_clone}
\title{Clone this}
\usage{
projects_post_clone(id, clone_schedule = NULL, clone_notifications = NULL)
}
\arguments{
\item{id}{integer required. The ID for this project.}

\item{clone_schedule}{boolean optional. If true, also copy the schedule for all applicable project objects.}

\item{clone_notifications}{boolean optional. If true, also copy the notifications for all applicable project objects.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for this project.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{name}{string, The name of this project.}
\item{description}{string, A description of the project.}
\item{users}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{autoShare}{boolean, }
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{tables}{array, An array containing the following fields: 
\itemize{
\item schema string, 
\item name string, 
\item rowCount integer, 
\item columnCount integer, 
\item createdAt string, 
\item updatedAt string, 
}}
\item{surveys}{array, An array containing the following fields: 
\itemize{
\item id integer, The item's ID.
\item createdAt string, 
\item updatedAt string, 
}}
\item{scripts}{array, An array containing the following fields: 
\itemize{
\item id integer, The item's ID.
\item createdAt string, 
\item updatedAt string, 
\item name string, 
\item type string, 
\item finishedAt string, 
\item state string, 
\item lastRun object, 
}}
\item{imports}{array, An array containing the following fields: 
\itemize{
\item id integer, The item's ID.
\item createdAt string, 
\item updatedAt string, 
\item name string, 
\item type string, 
\item finishedAt string, 
\item state string, 
\item lastRun object, 
}}
\item{exports}{array, An array containing the following fields: 
\itemize{
\item id integer, The item's ID.
\item createdAt string, 
\item updatedAt string, 
\item name string, 
\item type string, 
\item finishedAt string, 
\item state string, 
\item lastRun object, 
}}
\item{models}{array, An array containing the following fields: 
\itemize{
\item id integer, The item's ID.
\item createdAt string, 
\item updatedAt string, 
\item name string, 
\item state string, 
}}
\item{notebooks}{array, An array containing the following fields: 
\itemize{
\item id integer, The item's ID.
\item createdAt string, 
\item updatedAt string, 
\item name string, 
\item currentDeploymentId integer, 
\item lastDeploy object, 
}}
\item{services}{array, An array containing the following fields: 
\itemize{
\item id integer, The item's ID.
\item createdAt string, 
\item updatedAt string, 
\item name string, 
\item currentDeploymentId integer, 
\item lastDeploy object, 
}}
\item{workflows}{array, An array containing the following fields: 
\itemize{
\item id integer, The item's ID.
\item createdAt string, 
\item updatedAt string, 
\item name string, 
\item state string, 
\item lastExecution object, 
}}
\item{reports}{array, An array containing the following fields: 
\itemize{
\item id integer, The item's ID.
\item createdAt string, 
\item updatedAt string, 
\item name string, 
\item state string, 
}}
\item{scriptTemplates}{array, An array containing the following fields: 
\itemize{
\item id integer, The item's ID.
\item createdAt string, 
\item updatedAt string, 
\item name string, 
}}
\item{files}{array, An array containing the following fields: 
\itemize{
\item id integer, The item's ID.
\item createdAt string, 
\item updatedAt string, 
\item fileName string, 
\item fileSize integer, 
\item expired boolean, 
}}
\item{enhancements}{array, An array containing the following fields: 
\itemize{
\item id integer, The item's ID.
\item createdAt string, 
\item updatedAt string, 
\item name string, 
\item lastRun object, 
}}
\item{projects}{array, An array containing the following fields: 
\itemize{
\item id integer, The item's ID.
\item createdAt string, 
\item updatedAt string, 
\item name string, 
\item description string, 
}}
\item{allObjects}{array, An array containing the following fields: 
\itemize{
\item projectId integer, 
\item objectId integer, 
\item objectType string, 
\item fcoType string, 
\item subType string, 
\item name string, 
\item icon string, 
\item author string, 
\item updatedAt string, 
\item autoShare boolean, 
\item archived string, The archival status of the requested item(s).
\item hidden boolean, The hidden status of the item.
\item myPermissionLevel string, Your permission level on the object. One of "read", "write", or "manage".
}}
\item{note}{string, }
\item{canCurrentUserEnableAutoShare}{boolean, A flag for if the current user can enable auto-sharing mode for this project.}
\item{hidden}{boolean, The hidden status of the item.}
\item{archived}{string, The archival status of the requested item(s).}
\item{parentProject}{list, A list containing the following elements: 
\itemize{
\item id integer, The parent project's ID.
\item name integer, The parent project's name.
}}
\item{myPermissionLevel}{string, Your permission level on the object. One of "read", "write", or "manage".}
}
\description{
Clone this
}
