% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cja_get_dataviews.R
\name{cja_get_dataviews}
\alias{cja_get_dataviews}
\title{Get data view ids}
\usage{
cja_get_dataviews(
  expansion = c("name"),
  parentDataGroupId = NULL,
  externalIds = NULL,
  externalParentIds = NULL,
  dataviewIds = NULL,
  includeType = NULL,
  cached = TRUE,
  limit = 1000,
  page = 0,
  sortDirection = "ASC",
  sortProperty = "id",
  debug = FALSE
)
}
\arguments{
\item{expansion}{Comma-delimited list of additional fields to include on response. Options include: "name" "description" "owner" "isDeleted" "parentDataGroupId" "segmentList" "currentTimezoneOffset" "timezoneDesignator" "modified" "createdDate" "organization" "curationEnabled" "recentRecordedAccess" "sessionDefinition" "externalData" "containerNames"}

\item{parentDataGroupId}{Filters data views by a single parentDataGroupId}

\item{externalIds}{Comma-delimited list of external ids to limit the response with}

\item{externalParentIds}{Comma-delimited list of external parent ids to limit the response with.}

\item{dataviewIds}{Comma-delimited list of data view ids to limit the response with.}

\item{includeType}{Include additional DataViews not owned by user. Options: "deleted"}

\item{cached}{return cached results. TRUE (default) or FALSE}

\item{limit}{number of results per page. 10 is default}

\item{page}{Page number (base 0 - first page is 0). 0 is default}

\item{sortDirection}{Sort direction ('ASC' (default) or DESC)}

\item{sortProperty}{property to sort by (only modifiedDate and id are currently allowed). 'id' is default}

\item{debug}{Used to help troubleshoot api call issues. Shows the call and result in the console}
}
\value{
A data frame of dataview ids and their corresponding metadata
}
\description{
This function will pull a list of data views ids that you have access to. These are similar to report suites in Adobe Analytics.
}
\details{
\strong{Expansion} available items: "name" "description" "owner" "isDeleted"
"parentDataGroupId" "segmentList" "currentTimezoneOffset" "timezoneDesignator"
"modified" "createdDate" "organization" "curationEnabled" "recentRecordedAccess"
"sessionDefinition" "externalData" "containerNames"
}
\examples{
\dontrun{
cja_get_dataviews()
}
}
