% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pIMCE.R
\name{pIMCE}
\alias{pIMCE}
\title{Population-Weighted Heterogeneous Effects Analysis of Conjoint Results}
\usage{
pIMCE(
  model,
  covar_data,
  attribs,
  l,
  l_1,
  l_0,
  marginals,
  method = "bayes",
  alpha = 0.05,
  cores = 1,
  skip_checks = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{model}{A model object, the result of running \code{cjbart()}}

\item{covar_data}{A data.frame of covariate information to predict pIMCEs over}

\item{attribs}{Vector of attribute names}

\item{l}{Name of the attribute of interest}

\item{l_1}{Attribute-level of interest for attribute \emph{l}}

\item{l_0}{Reference level for attribute \emph{l}}

\item{marginals}{A named list where every element is a named vector of marginal probabilities for each corresponding attribute-level.  For example, \code{marginals = list("A1" = c("q" = 0.4, "r" = 0.6), "A2" = c("x" = 0.7, "y" = 0.2, "z" = 0.1))}}

\item{method}{Character string, setting the variance estimation method to use. When method is "parametric", a typical combined variance estimate is employed; when \code{method = "bayes"}, the 95\% posterior interval is calculated; and when \code{method = "rubin"}, combination rules are used to combine the variance analogous to in multiple imputation analysis.}

\item{alpha}{Number between 0 and 1 -- the significance level used to compute confidence/posterior intervals. When \code{method = "bayes"}, the posterior interval is calculated by taking the alpha/2 and (1-alpha/2) quantiles of the posterior draws. When \code{method = "rubin"}, the confidence interval equals the IMCE +/- \code{qnorm(alpha/2)}. By default, alpha is 0.05 i.e. generating a 95\% confidence/posterior interval.}

\item{cores}{Number of CPU cores used during prediction phase}

\item{skip_checks}{Boolean, indicating whether to check the structure of the data (default = \code{FALSE}). Only set this to \code{TRUE} if you are confident that the data is structured appropriately}

\item{verbose}{Boolean, indicating whether to print progress (default = TRUE)}
}
\value{
\code{pIMCE} returns a data.frame of population-weighted estimates, credible interval bounds, and the covariate information supplied
}
\description{
\code{pIMCE} calculates the population individual-level marginal component effects from a BART-estimated conjoint model, using marginal attribute distributions specified by the researcher.
}
\details{
This function calculates the population-weighted IMCE, which takes into account the population distribution of profiles. Rather than average over the multiple OMCE estimates, this function generates estimated treatment effects for \emph{all} possible potential outcomes along all attributes except the attribute of interest, and then marginalizes these over the supplied marginal distributions. Uncertainty estimates are recovered using credible intervals.
}
\seealso{
\code{\link[=cjbart]{cjbart()}}
}
