% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_patch.R
\name{resource_patch}
\alias{resource_patch}
\title{Update a resource's metadata}
\usage{
resource_patch(x, id, url = get_default_url(), key = get_default_key(),
  as = "list", ...)
}
\arguments{
\item{x}{(list) A list with key-value pairs}

\item{id}{(character) Resource ID to update (required)}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Update a resource's metadata
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org", key = getOption("ckan_demo_key"))

# Get a resource
res <- resource_show("b85948b6-f9ea-4392-805e-00511d6cf6c6")
res$description

# Make some changes
x <- list(description = "My newer description")
resource_patch(x, id = res)
# or pass id in directly
# resource_patch(x, id = res$id)
}
}
