% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clam-package.R, R/clam.R
\docType{package}
\name{clam}
\alias{clam}
\title{clam: Classical Age-Depth Modelling of Cores from Deposits}
\usage{
clam(
  core = "Example",
  type = 1,
  smooth = NULL,
  prob = 0.95,
  its = 1000,
  coredir = NULL,
  ask = TRUE,
  wghts = 1,
  cc = 1,
  cc1 = "3Col_intcal20.14C",
  cc2 = "3Col_marine20.14C",
  cc3 = "3Col_shcal20.14C",
  cc4 = "mixed.14C",
  postbomb = FALSE,
  pb1 = "postbomb_NH1.14C",
  pb2 = "postbomb_NH2.14C",
  pb3 = "postbomb_NH3.14C",
  pb4 = "postbomb_SH1-2.14C",
  pb5 = "postbomb_SH3.14C",
  ccdir = "",
  outliers = NULL,
  ignore = NULL,
  youngest = NULL,
  extradates = NULL,
  slump = NULL,
  est = 1,
  calibt = FALSE,
  mixed.effect = FALSE,
  dmin = NULL,
  dmax = NULL,
  every = 1,
  yrmin = NULL,
  yrmax = NULL,
  yrsteps = 1,
  pbsteps = 0.01,
  hpdsteps = 1,
  BCAD = FALSE,
  decimals = 0,
  cmyr = FALSE,
  ageofdepth = NULL,
  depth = "cm",
  depthseq = NULL,
  depths.file = FALSE,
  thickness = 1,
  hiatus = NULL,
  remove.reverse = 0.5,
  times = 5,
  sep = ",",
  ext = ".csv",
  runname = NULL,
  storedat = TRUE,
  threshold = 1e-06,
  proxies = FALSE,
  revaxes = FALSE,
  revd = TRUE,
  revyr = TRUE,
  calhght = 0.3,
  maxhght = 0.01,
  mirror = TRUE,
  plotrange = TRUE,
  bty = "l",
  mar = c(3.5, 3, 2, 1),
  mgp = c(2, 1, 0),
  plotpdf = TRUE,
  plotpng = TRUE,
  greyscale = NULL,
  yrlab = NULL,
  dlab = NULL,
  calcol = rgb(0, 0.5, 0.5, 0.5),
  C14col = rgb(0, 0, 1, 0.5),
  outcol = "red",
  outlsize = 1,
  bestcol = "black",
  rangecol = rgb(0, 0, 0, 0.3),
  slumpcol = grey(0.75),
  plotname = TRUE,
  ash = FALSE,
  rule = 1
)
}
\arguments{
\item{core}{Name of the core, given using quotes. Defaults to the core provided with clam, \code{core="Example"}.}

\item{type}{The type of age-depth model. Five different types are provided:
\enumerate{
 \item linear interpolation between neighbouring levels (1, "int", "inter" or "interp") 
 \item linear or higher polynomial regression (2, "reg", "regr", "poly" or "polyn", default linear) 
 \item cubic spline (3, "spl" or "spline") 
 \item smooth spline (4, "sm" or "smooth", default smoothing 0.3) 
 \item locally weighted spline (5, "loess" or "lowess", default smoothing 0.75, cannot extrapolate)
}}

\item{smooth}{Degree of smoothing. Gives polynomial degree for model type 2. Not relevant for \code{type=1 or type=3}.
\itemize{
 \item for type=2: \code{smooth=1} (linear), \code{smooth=2} second-order polynomial, \code{smooth=3} for third-order polynomial, etc. 
 \item for type=4: \code{smooth=0.3} 
 \item for type=5: \code{smooth=0.75} 
}}

\item{prob}{Confidence intervals (between 0 and 1), default \code{prob=0.95} or 95\%.}

\item{its}{Amount of age-model iterations; defaults to \code{its=1000}.}

\item{coredir}{The directory where core runs are stored (each core in its own directory named after the core's name).}

\item{ask}{By default, and as per R rules, clam will ask if it is OK to make or write to a directory.
Defaults to \code{coredir="clam_runs"}, or to \code{coredir="Cores"} if this folder exists where R is working.}

\item{wghts}{Weights can be applied to dated depths as follows:
\itemize{
 \item 0 no weighting 
 \item 1 weighted to calibrated probabilities of sampled calendar years (default, \code{wghts=1}). 
 \item 2 weighted to (inverse squared) errors of the dates.
}}

\item{cc}{calibration curve for C14 dates (1, 2 or 3).}

\item{cc1}{For terrestrial, northern hemisphere C14 dates.}

\item{cc2}{For marine C14 dates.}

\item{cc3}{For southern hemisphere C14 dates.}

\item{cc4}{For mixed terrestrial/marine C14 dates.}

\item{postbomb}{Use a postbomb curve for negative (i.e. postbomb) 14C ages. \code{0 = none, 1 = NH1, 2 = NH2, 3 = NH3, 4 = SH1-2, 5 = SH3}. See \url{http://calib.org/CALIBomb/}.}

\item{pb1}{For Northern hemisphere region 1 postbomb C14 dates.}

\item{pb2}{For Northern hemisphere region 2 postbomb C14 dates.}

\item{pb3}{For Northern hemisphere region 3 postbomb C14 dates.}

\item{pb4}{For Southern hemisphere regions 1-2 postbomb C14 dates.}

\item{pb5}{For Southern hemisphere region 3 postbomb C14 dates.}

\item{ccdir}{Directory where the calibration curves for C14 dates \code{cc} are located. By default \code{ccdir=""}. 
For example, use \code{ccdir="."} to choose current working directory, or \code{ccdir="Curves/"} to choose sub-folder \code{Curves/}.}

\item{outliers}{The number of any dates to be considered outlying, e.g. \code{c(5,6)} for the fifth and sixth dated depth counting from the top of a core.}

\item{ignore}{The number of any dates that should be ignored, e.g., \code{c(5,6)} for the fifth and sixth date counting from the top of a core.}

\item{youngest}{The age beyond which dates should be truncated (e.g., \code{youngest=-60} if the core was sampled in -60 cal BP or AD 2010).}

\item{extradates}{Depths of any additional dates with their files of ages and probabilities.}

\item{slump}{Upper and lower depths of sections of abrupt accumulation that should be excised, e.g., \code{c(600, 550, 120, 100)} for two sections of 600-550 and 120-100 cm depth.}

\item{est}{Which point estimate to use as 'best' age. It is highly recommended to not only use these 'best' point estimates, as chronological uncertainties are often considerable and should not be ignored.
\enumerate{
 \item averages of age-depth model derived ages (default, \code{est=1})
 \item midpoints of age-depth model derived age estimates
 \item midpoints of calibrated ranges
 \item weighted means of calibrated ranges 
 \item medians of calibrated distributions 
 \item maximum densities of calibrated distributions 
 \item midpoints of entire calibrated distributions (including years outside the calibrated ranges)
}}

\item{calibt}{Calibration based on the student-t distribution. By default, the Gaussian distribution is used (\code{calibt=FALSE}). To use the student-t distribution, provide two parameters such as \code{calibt=c(3,4)}.}

\item{mixed.effect}{Set to \code{TRUE} to activate mixed-effect modelling.}

\item{dmin}{Minimum depth of age-depth model (e.g., extrapolate).}

\item{dmax}{Maximum depth of age-depth model (e.g., extrapolate).}

\item{every}{Resolution at which (ages for) depths are calculated.}

\item{yrmin}{Minimum of calendar axis of age-depth plot (calculate automatically by default).}

\item{yrmax}{Maximum of calendar axis of age-depth plot (calculated automatically by default).}

\item{yrsteps}{Temporal resolution at which calibrated ages are calculated (in calendar years).}

\item{pbsteps}{Temporal resolution at which postbomb C14 ages are calibrated (in calendar years).}

\item{hpdsteps}{Temporal resolution at which highest posterior density ranges are calibrated (in calendar years).}

\item{BCAD}{Use BC/AD or cal BP scale.}

\item{decimals}{Amount of decimals for rounding.}

\item{cmyr}{Accumulation rates can be provided as yr/cm (default, \code{cmyr=TRUE}, more accurately named deposition times) or cm/yr (\code{cmyr=FALSE}).}

\item{ageofdepth}{Calculate age estimates of a specific depth.}

\item{depth}{Depth units.}

\item{depthseq}{Sequence of depths for which age estimates are to be calculated (default: from \code{dmin} to \code{dmax} with steps of size every)}

\item{depths.file}{Use a file with depths for depthseq.}

\item{thickness}{Thickness of the dated samples.}

\item{hiatus}{Depths of any hiatuses, e.g., \code{c(500, 300)}. Each sub-section must have at least 2 dates (\code{4} for smoothing spline; does not work with loess as it cannot extrapolate).}

\item{remove.reverse}{Proportion of age-models with reversals that can be removed before prompting a warning.
Set at \code{FALSE} to avoid removing models with reversals.}

\item{times}{Half-range of calibration curve used to calibrate dates (multiplication factor for the dates' errors).}

\item{sep}{Separator between the fields of the plain text file containing the dating information.}

\item{ext}{Extension of the file containing the dating information.}

\item{runname}{Text to add to the core name for specific runs, e.g., "MyCore_Test1"}

\item{storedat}{Store the dates and age-model within R after a \code{clam} run. Defaults to \code{storedat=TRUE}.}

\item{threshold}{Below which value should probabilities be excluded from calculations.}

\item{proxies}{Set to \code{TRUE} to plot proxies against age after the run.}

\item{revaxes}{Set to \code{TRUE} to plot ages on the vertical axis and depth on the horizontal axis.}

\item{revd}{Plot depth axis in reverse.}

\item{revyr}{Plot age axis in reverse.}

\item{calhght}{Heights of the calibrated distributions in the age-depth plot.}

\item{maxhght}{Maximum height of age probability distributions.}

\item{mirror}{Plot the age distributions in "mirror" style (above and below depth).}

\item{plotrange}{Plot the confidence ranges of the age-model.}

\item{bty}{Type of box to be drawn around plots. Draw a box around the graph (\code{"n"} for none, 
and \code{"l"}, \code{"7"}, \code{"c"}, \code{"u"}, "]" or \code{"o"} for correspondingly shaped boxes).}

\item{mar}{Plot margins (amount of white space along edges of axes 1-4).}

\item{mgp}{Axis text margins (where should titles, labels and tick marks be plotted).}

\item{plotpdf}{Produce a pdf file of the age-depth plot.}

\item{plotpng}{Produce a png file of the age-depth plot.}

\item{greyscale}{Produce a grey-scale representation of all age-models (number gives resolution, e.g., 500 bins; will cancel plotting of the confidence intervals).}

\item{yrlab}{Label of the calendar axis. Defaults to either cal BP or BC/AD. Alternative names can be provided.}

\item{dlab}{Label of the depth axis. Defaults to \code{dlab="Depth (cm)"} (assuming \code{depth="cm"}), but alternative names can be provided.}

\item{calcol}{Colour of the calibrated distributions in the age-depth plot.}

\item{C14col}{Colour of the calibrated ranges of the dates.}

\item{outcol}{Colour of outlying dates.}

\item{outlsize}{Size of symbols outlying dates.}

\item{bestcol}{Colour of the "best" age-depth model (based on chosen value for est).}

\item{rangecol}{Colour of plotted confidence ranges.}

\item{slumpcol}{Colour of slump.}

\item{plotname}{Print the core name on the graph.}

\item{ash}{Plot all distributions at the same height.}

\item{rule}{How should R's approx function deal with extrapolation. If \code{rule=1}, the default, then NAs are returned for such points and if it is 2, the value at the closest data extreme is used.}
}
\value{
Age model construction together with a text output and files saved to a folder in the \code{coredir/core} directory.
}
\description{
Performs 'classical' age-depth modelling of dated sediment deposits - prior to applying more sophisticated techniques such as Bayesian age-depth modelling. Any radiocarbon dated depths are calibrated. Age-depth models are constructed by sampling repeatedly from the dated levels, each time drawing age-depth curves. Model types include linear interpolation, linear or polynomial regression, and a range of splines. See Blaauw (2010). <doi:10.1016/j.quageo.2010.01.002>.

Produce age-depth models for cores with dated depths.
}
\details{
Cores containing several 14C and/or other dates can be processed semi-automatically in order to obtain age-depth models. 
In the process, any 14C dates are calibrated, and age-depth curves are repeatedly drawn through point estimates sampled from the dates.
 Age-depth models can be based on linear interpolation, linear/polynomial regression, or cubic, smooth or locally weighted splines. 
 For each date, the probability of a calendar year being sampled is proportionate to its calibrated probability (see Blaauw, 2010). 
 Uncertainty ranges as well as a 'best' age-model are calculated.

Additional cores should be put in a comma-separated file in a sub-folder of the directory where the cores are stored. 
By default this parent folder is called \code{coredir="clam_runs"} (if no folder called \code{"Cores"} already exists). If your core is called MyCore1, save MyCore1.csv as \code{clam_runs/MyCore1/MyCore1.csv}.
Ensure that the names of the core's folder and filename's root (the part before .csv) match, e.g., using exactly similar upper- and lower case letters.

Avoid the use of spaces or non-standard (non-ASCII) characters within the file or in folder or file names. 
The plain text file should consist of 6 or 7 columns (also called fields), containing in the following exact order (see the example below):
 \enumerate{
  \item Identification labels (e.g. 14C lab codes)
  \item 14C ages for 14C-dated depths; leave empty for non-14C dated depths
  \item cal BP ages (for any non-14C dates such as the core surface; leave empty for levels with 14C dates)
  \item errors (reported 1 standard deviation errors. This column should never be left empty. Errors should always be larger than 0)
  \item age offsets if known (otherwise leave empty)
  \item depths (depths in the sequence were the dated samples were taken, default unit depth="cm"; this column should never be left empty)
  \item thicknesses of the sampled slices (optional column; leave empty for default of 1)
 }
Add a final empty line to your core's .csv file by pressing 'Enter' after the file's last value. 

These files can be made in spreadsheet software such as MS-Excel, but it is always a good idea to check the file's formatting in a plain-text editor such as WordPad. Remove any lines which contain only commas, and it is also recommended to remove quotes ()\code{\" or \'}) in the headers or elsewhere. 

Age-models for the core can then be produced by typing, e.g., \code{clam("MyCore1")}.

By default the northern hemisphere terrestrial calibration curve is used (\code{cc=1}, \code{cc1="3Col_intcal20.14C"}). 
To use alternative curves, change \code{cc} to \code{cc=2 (cc2="3Col_marine20.14C")}, \code{cc=3 (cc3="3Col_shcal20.14C")}, \code{cc=4 (cc4="mixed.14C")}. 
You can also provide custom-built calibration curves, indicating its location using \code{ccdir}.

The provided example (default \code{core="Example"}) is core Quilichao-1 which was sampled from a Colombian lake (Berrio et al., 2002). 
This core was chosen because it was dated at a rather high resolution, and appears to contain a hiatus (e.g., try \code{hiatus=450}
for a hiatus at 450 cm depth).

Each clam run will produce a range of files within the core's folder. One, ending with \code{"_calibrated.txt"} contains the calibrated 
age ranges of the 14C and other dates. The others will be named according to the core's name followed by the model type, 
and contain the age estimates for all depths (files ending with \code{"_ages.txt"}), settings (files ending with \code{"_settings.txt"}) 
and graphs (files ending with \code{".pdf"} and \code{".png"}). 
The file containing the age estimates has 5 columns; first the depths, then the minima and maxima of the confidence intervals, 
then a "best" estimate, and finally the reconstructed accumulation rates. The reported values are rounded to 0 decimals by default
(\code{decimals=0}). Accumulation rates are in yr/cm ("deposition time") by default (\code{cmyr=FALSE}), but can be reported in cm/yr (\code{cmyr=TRUE}).

see Blaauw 2010 (Quaternary Geochronology 5: 512-518).
}
\examples{
  base_temp_dir <- tempdir()
  clam_dir <- file.path(base_temp_dir, "clam_runs")
  dir.create(clam_dir, recursive = TRUE, showWarnings = FALSE)
  clam(, coredir=clam_dir, ask=FALSE) 
  clam(, coredir=clam_dir, ask=FALSE, extradates=470)

}
\references{
Berrio, J.C., Hooghiemstra, H., Marchant, R., Rangel, O., 2002. Late-glacial and Holocene history of the dry forest area 
in the south Colombian Cauca Valley. Journal of Quaternary Science 17, 667-682

Blaauw, M., 2010. Methods and code for 'classical' age-modelling of radiocarbon sequences. Quaternary Geochronology 5, 512-518
\doi{10.1016/j.quageo.2010.01.002}
}
\author{
Maarten Blaauw <maarten.blaauw@qub.ac.uk>

Maarten Blaauw
}
