\name{ggPermHist}
\alias{ggPermHist}
\title{
Permutation Histograms
}
\description{
The \code{ggPermHist} function generates a histogram of the permutation results as generated by \code{\link{cfPermute}}.
}
\usage{
ggPermHist(permObj, density = FALSE, percentiles = FALSE, mean = FALSE, 
           median = FALSE, ...)
}
\arguments{
  \item{permObj}{The permutation object as generated by \code{\link{cfPermute}}}
  \item{density}{Boolean value, by default equal to \code{FALSE}. If \code{density = FALSE}, the histogram depicts frequencies, the counts component of the result. Instead, for \code{density = TRUE}, probability densities are plotted.}
  \item{percentiles}{Boolean value, by default equal to \code{FALSE}. If \code{percentiles = TRUE}, the upper and lower percentiles of the distribution are depicted in the plot.}
  \item{mean}{Boolean value, by default equal to \code{FALSE}. If \code{mean = TRUE}, the mean of the distribution is depicted in the plot.}
  \item{median}{Boolean value, by default equal to \code{FALSE}. If \code{median = TRUE}, the median of the distribution is depicted in the plot.}
  \item{\dots}{Further arguments and graphical parameters passed to the ggplot.}
}
\seealso{
  \code{
    \link{ggEnsHist}
  }
}
\examples{
\dontrun{
data(iris)

irisClass <- iris[,5]
irisData  <- iris[,-5]

permObj <- cfPermute(irisData, irisClass, bootNum = 10, ensNum = 20, permNum = 5, 
                     parallel = TRUE, cpus = 4, type = "SOCK")

ggPermHist(permObj)
ggPermHist(permObj, density=TRUE)
ggPermHist(permObj, density=TRUE, percentiles = TRUE, mean = TRUE)
ggPermHist(permObj, density=TRUE, percentiles = TRUE, median = TRUE)
}
}
\keyword{hplot}
